/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServerHandlerCollection;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.http.HttpContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerWrapper
extends Server {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerWrapper.class);
    private final ServerModel serverModel;
    private final Map<HttpContext, ServletContextInfo> contexts = new IdentityHashMap<HttpContext, ServletContextInfo>();
    private Map<String, Object> contextAttributes;
    private Integer sessionTimeout;
    private String sessionCookie;
    private String sessionDomain;
    private String sessionPath;
    private String sessionUrl;
    private String sessionWorkerName;
    private Boolean lazyLoad;
    private String storeDirectory;
    private File serverConfigDir;
    private URL serverConfigURL;
    private Boolean sessionCookieHttpOnly;
    private Boolean sessionCookieSecure;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private Bundle jettyBundle;
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;

    JettyServerWrapper(ServerModel serverModel, ThreadPool threadPool) {
        super(threadPool);
        this.serverModel = serverModel;
        this.setHandler((Handler)new JettyServerHandlerCollection(serverModel));
        this.jettyBundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        if (this.jettyBundle != null) {
            Filter filterPackage = null;
            try {
                filterPackage = this.jettyBundle.getBundleContext().createFilter("(objectClass=org.osgi.service.packageadmin.PackageAdmin)");
            }
            catch (InvalidSyntaxException e) {
                LOG.error("InvalidSyntaxException while waiting for PackageAdmin Service", (Throwable)e);
            }
            this.packageAdminTracker = new ServiceTracker(this.jettyBundle.getBundleContext(), filterPackage, null);
            this.packageAdminTracker.open();
        }
    }

    public void configureContext(Map<String, Object> attributes, Integer timeout, String cookie, String domain, String path, String url, Boolean cookieHttpOnly, Boolean sessionCookieSecure, String workerName, Boolean lazy, String directory) {
        this.contextAttributes = attributes;
        this.sessionTimeout = timeout;
        this.sessionCookie = cookie;
        this.sessionDomain = domain;
        this.sessionPath = path;
        this.sessionUrl = url;
        this.sessionCookieHttpOnly = cookieHttpOnly;
        this.sessionCookieSecure = sessionCookieSecure;
        this.sessionWorkerName = workerName;
        this.lazyLoad = lazy;
        this.storeDirectory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpServiceContext getContext(HttpContext httpContext) {
        this.readLock.lock();
        try {
            ServletContextInfo servletContextInfo = this.contexts.get(httpContext);
            if (servletContextInfo != null) {
                HttpServiceContext httpServiceContext = servletContextInfo.getHandler();
                return httpServiceContext;
            }
            HttpServiceContext httpServiceContext = null;
            return httpServiceContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    HttpServiceContext getOrCreateContext(Model model) {
        return this.getOrCreateContext(model.getContextModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpServiceContext getOrCreateContext(ContextModel model) {
        ServletContextInfo context;
        block9: {
            HttpContext httpContext = model.getHttpContext();
            context = null;
            try {
                this.readLock.lock();
                if (this.contexts.containsKey(httpContext)) {
                    context = this.contexts.get(httpContext);
                    context.incrementRefCount();
                    break block9;
                }
                try {
                    this.readLock.unlock();
                    this.writeLock.lock();
                    if (!this.contexts.containsKey(httpContext)) {
                        LOG.debug("Creating new ServletContextHandler for HTTP context [{}] and model [{}]", (Object)httpContext, (Object)model);
                        context = new ServletContextInfo(this.addContext(model));
                        this.contexts.put(httpContext, context);
                    } else {
                        context = this.contexts.get(httpContext);
                        context.incrementRefCount();
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return context.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContext(HttpContext httpContext, boolean force) {
        ServletContextInfo context;
        block12: {
            try {
                this.readLock.lock();
                context = this.contexts.get(httpContext);
                if (context == null) {
                    return;
                }
                int nref = context.decrementRefCount();
                if (force && !(httpContext instanceof SharedWebContainerContext) || nref <= 0) {
                    try {
                        this.readLock.unlock();
                        this.writeLock.lock();
                        LOG.debug("Removing ServletContextHandler for HTTP context [{}].", (Object)httpContext);
                        context = this.contexts.remove(httpContext);
                        break block12;
                    }
                    finally {
                        this.readLock.lock();
                        this.writeLock.unlock();
                    }
                }
                LOG.debug("ServletContextHandler for HTTP context [{}] referenced [{}] times.", (Object)httpContext, (Object)nref);
                return;
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (context != null) {
            HttpServiceContext sch = context.getHandler();
            try {
                sch.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sch.getServletHandler().setServer(null);
            sch.getSecurityHandler().setServer(null);
            sch.getSessionHandler().setServer(null);
            sch.getErrorHandler().setServer(null);
            ((HandlerCollection)this.getHandler()).removeHandler((Handler)sch);
            sch.destroy();
        }
    }

    private HttpServiceContext addContext(ContextModel model) {
        HttpServiceContext context;
        block29: {
            String workerName;
            Boolean modelSessionSecure;
            Boolean modelSessionCookieHttpOnly;
            String modelSessionUrl;
            String modelSessionPath;
            String modelSessionDomain;
            String modelSessionCookie;
            Bundle bundle = model.getBundle();
            BundleContext bundleContext = BundleUtils.getBundleContext(bundle);
            Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new HashSet());
            if (this.jettyBundle != null) {
                ClassPathUtil.getBundlesInClassSpace((Bundle)this.jettyBundle, (Set)bundlesInClassSpace);
            }
            for (URL u : ClassPathUtil.findResources((Iterable)bundlesInClassSpace, (String)"/META-INF/services", (String)"javax.servlet.ServletContainerInitializer", (boolean)true)) {
                try {
                    Class initializerClass;
                    InputStream is = u.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    String className = reader.readLine();
                    LOG.info("will add {} to ServletContainerInitializers", (Object)className);
                    if (className.endsWith("JasperInitializer")) {
                        LOG.info("Skipt {}, because specialized handler will be present", (Object)className);
                        continue;
                    }
                    try {
                        initializerClass = bundle.loadClass(className);
                    }
                    catch (ClassNotFoundException ignore) {
                        initializerClass = this.jettyBundle.loadClass(className);
                    }
                    HashMap containerInitializers = model.getContainerInitializers();
                    ServletContainerInitializer initializer = (ServletContainerInitializer)initializerClass.newInstance();
                    if (containerInitializers == null) {
                        containerInitializers = new HashMap();
                        model.setContainerInitializers(containerInitializers);
                    }
                    HashSet<Class> setOfClasses = new HashSet<Class>();
                    HandlesTypes handlesTypes = initializerClass.getAnnotation(HandlesTypes.class);
                    if (handlesTypes != null) {
                        Class[] classes;
                        for (Class klass : classes = handlesTypes.value()) {
                            BundleAssignableClassFinder basf;
                            boolean isAnnotation = klass.isAnnotation();
                            boolean isInteraface = klass.isInterface();
                            if (isAnnotation) {
                                try {
                                    BundleAnnotationFinder baf = new BundleAnnotationFinder((PackageAdmin)this.packageAdminTracker.getService(), bundle);
                                    List annotatedClasses = baf.findAnnotatedClasses(klass);
                                    setOfClasses.addAll(annotatedClasses);
                                }
                                catch (Exception e) {
                                    LOG.warn("Failed to find annotated classes for ServletContainerInitializer", (Throwable)e);
                                }
                                continue;
                            }
                            if (isInteraface) {
                                basf = new BundleAssignableClassFinder((PackageAdmin)this.packageAdminTracker.getService(), new Class[]{klass}, bundle);
                                Set interfaces = basf.find();
                                for (String interfaceName : interfaces) {
                                    setOfClasses.add(bundle.loadClass(interfaceName));
                                }
                                continue;
                            }
                            basf = new BundleAssignableClassFinder((PackageAdmin)this.packageAdminTracker.getService(), new Class[]{klass}, bundle);
                            Set classNames = basf.find();
                            for (String klassName : classNames) {
                                setOfClasses.add(bundle.loadClass(klassName));
                            }
                        }
                    }
                    containerInitializers.put(initializer, setOfClasses);
                    LOG.info("added ServletContainerInitializer: {}", (Object)className);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LOG.warn("failed to parse and instantiate of javax.servlet.ServletContainerInitializer in classpath");
                }
            }
            context = new HttpServiceContext((HandlerContainer)this.getHandler(), model.getContextParams(), this.getContextAttributes(bundleContext), model.getContextName(), model.getHttpContext(), model.getAccessControllerContext(), model.getContainerInitializers(), model.getJettyWebXmlURL(), model.getVirtualHosts());
            context.setClassLoader(model.getClassLoader());
            Integer modelSessionTimeout = model.getSessionTimeout();
            if (modelSessionTimeout == null) {
                modelSessionTimeout = this.sessionTimeout;
            }
            if ((modelSessionCookie = model.getSessionCookie()) == null) {
                modelSessionCookie = this.sessionCookie;
            }
            if ((modelSessionDomain = model.getSessionDomain()) == null) {
                modelSessionDomain = this.sessionDomain;
            }
            if ((modelSessionPath = model.getSessionPath()) == null) {
                modelSessionPath = this.sessionPath;
            }
            if ((modelSessionUrl = model.getSessionUrl()) == null) {
                modelSessionUrl = this.sessionUrl;
            }
            if ((modelSessionCookieHttpOnly = model.getSessionCookieHttpOnly()) == null) {
                modelSessionCookieHttpOnly = this.sessionCookieHttpOnly;
            }
            if ((modelSessionSecure = model.getSessionCookieSecure()) == null) {
                modelSessionSecure = this.sessionCookieSecure;
            }
            if ((workerName = model.getSessionWorkerName()) == null) {
                workerName = this.sessionWorkerName;
            }
            this.configureSessionManager(context, modelSessionTimeout, modelSessionCookie, modelSessionDomain, modelSessionPath, modelSessionUrl, modelSessionCookieHttpOnly, modelSessionSecure, workerName, this.lazyLoad, this.storeDirectory);
            if (model.getRealmName() != null && model.getAuthMethod() != null) {
                this.configureSecurity(context, model.getRealmName(), model.getAuthMethod(), model.getFormLoginPage(), model.getFormErrorPage());
            }
            LOG.debug("Added servlet context: " + (Object)((Object)context));
            if (this.isStarted()) {
                try {
                    LOG.debug("(Re)starting servlet contexts...");
                    Handler serverHandler = this.getHandler();
                    if (serverHandler.isStarted() || serverHandler.isStarting()) break block29;
                    serverHandler.start();
                }
                catch (Exception ignore) {
                    LOG.error("Could not start the servlet context for http context [" + model.getHttpContext() + "]", (Throwable)ignore);
                    if (!(ignore instanceof MultiException)) break block29;
                    LOG.error("MultiException found: ");
                    MultiException mex = (MultiException)ignore;
                    List throwables = mex.getThrowables();
                    for (Throwable throwable : throwables) {
                        LOG.error(throwable.getMessage());
                    }
                }
            }
        }
        return context;
    }

    private void configureSecurity(ServletContextHandler context, String realmName, String authMethod, String formLoginPage, String formErrorPage) {
        SecurityHandler securityHandler = context.getSecurityHandler();
        FormAuthenticator authenticator = null;
        if (authMethod == null) {
            LOG.warn("UNKNOWN AUTH METHOD: " + authMethod);
        } else {
            switch (authMethod) {
                case "FORM": {
                    authenticator = new FormAuthenticator();
                    securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", formLoginPage);
                    securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", formErrorPage);
                    break;
                }
                case "BASIC": {
                    authenticator = new BasicAuthenticator();
                    break;
                }
                case "DIGEST": {
                    authenticator = new DigestAuthenticator();
                    break;
                }
                case "CLIENT_CERT": {
                    authenticator = new ClientCertAuthenticator();
                    break;
                }
                case "CLIENT-CERT": {
                    authenticator = new ClientCertAuthenticator();
                    break;
                }
                case "SPNEGO": {
                    authenticator = new SpnegoAuthenticator();
                    break;
                }
                default: {
                    LOG.warn("UNKNOWN AUTH METHOD: " + authMethod);
                }
            }
        }
        securityHandler.setAuthenticator((Authenticator)authenticator);
        securityHandler.setRealmName(realmName);
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.contextAttributes != null) {
            attributes.putAll(this.contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionManager(ServletContextHandler context, Integer minutes, String cookie, String domain, String path, String url, Boolean cookieHttpOnly, Boolean secure, String workerName, Boolean lazy, String directory) {
        SessionManager sessionManager;
        LOG.debug("configureSessionManager for context [" + context + "] using - timeout:" + minutes + ", cookie:" + cookie + ", url:" + url + ", cookieHttpOnly:" + cookieHttpOnly + ", workerName:" + workerName + ", lazyLoad:" + lazy + ", storeDirectory: " + directory);
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            if (minutes != null) {
                sessionManager.setMaxInactiveInterval(minutes * 60);
                LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
            }
            if (cookie == null || "none".equals(cookie)) {
                if (sessionManager instanceof AbstractSessionManager) {
                    ((AbstractSessionManager)sessionManager).setUsingCookies(false);
                    LOG.debug("Session cookies disabled for context [" + context + "]");
                } else {
                    LOG.debug("SessionManager isn't of type AbstractSessionManager therefore using cookies unchanged!");
                }
            } else {
                sessionManager.getSessionCookieConfig().setName(cookie);
                LOG.debug("Session cookie set to " + cookie + " for context [" + context + "]");
                sessionManager.getSessionCookieConfig().setHttpOnly(cookieHttpOnly.booleanValue());
                LOG.debug("Session cookieHttpOnly set to " + cookieHttpOnly + " for context [" + context + "]");
            }
            if (domain != null && domain.length() > 0) {
                sessionManager.getSessionCookieConfig().setDomain(domain);
                LOG.debug("Session cookie domain set to " + domain + " for context [" + context + "]");
            }
            if (path != null && path.length() > 0) {
                sessionManager.getSessionCookieConfig().setPath(path);
                LOG.debug("Session cookie path set to " + path + " for context [" + context + "]");
            }
            if (secure != null) {
                sessionManager.getSessionCookieConfig().setSecure(secure.booleanValue());
                LOG.debug("Session cookie secure set to " + secure + " for context [" + context + "]");
            }
            if (url != null) {
                sessionManager.setSessionIdPathParameterName(url);
                LOG.debug("Session URL set to " + url + " for context [" + context + "]");
            }
            if (workerName != null) {
                SessionIdManager sessionIdManager = sessionManager.getSessionIdManager();
                if (sessionIdManager == null) {
                    sessionIdManager = new HashSessionIdManager();
                    sessionManager.setSessionIdManager(sessionIdManager);
                }
                if (sessionIdManager instanceof AbstractSessionIdManager) {
                    AbstractSessionIdManager s = (AbstractSessionIdManager)sessionIdManager;
                    s.setWorkerName(workerName);
                    LOG.debug("Worker name set to " + workerName + " for context [" + context + "]");
                }
            }
            if (lazy != null) {
                LOG.debug("is LazyLoad active? {}", (Object)lazy);
                if (sessionManager instanceof HashSessionManager) {
                    ((HashSessionManager)sessionManager).setLazyLoad(lazy.booleanValue());
                }
            }
            if (directory != null) {
                LOG.debug("storeDirectoy set to: {}", (Object)directory);
                if (sessionManager instanceof HashSessionManager) {
                    File storeDir = null;
                    try {
                        storeDir = new File(directory);
                        ((HashSessionManager)sessionManager).setStoreDirectory(storeDir);
                    }
                    catch (IOException e) {
                        LOG.warn("IOException while trying to set the StoreDirectory on the session Manager", (Throwable)e);
                    }
                }
            }
        }
    }

    public void setServerConfigDir(File serverConfigDir) {
        this.serverConfigDir = serverConfigDir;
    }

    public File getServerConfigDir() {
        return this.serverConfigDir;
    }

    public URL getServerConfigURL() {
        return this.serverConfigURL;
    }

    public void setServerConfigURL(URL serverConfigURL) {
        this.serverConfigURL = serverConfigURL;
    }

    private static final class ServletContextInfo {
        private final HttpServiceContext handler;
        private final AtomicInteger refCount = new AtomicInteger(1);

        public ServletContextInfo(HttpServiceContext handler) {
            this.handler = handler;
        }

        public int incrementRefCount() {
            return this.refCount.incrementAndGet();
        }

        public int decrementRefCount() {
            return this.refCount.decrementAndGet();
        }

        public HttpServiceContext getHandler() {
            return this.handler;
        }
    }
}

