/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.net.URI;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.Converter;
import org.apache.sling.auth.oauth_client.impl.OAuthException;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenRefresher;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.apache.sling.auth.oauth_client.impl.ResolvedOAuthConnection;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component
public class OAuthTokenRefresherImpl
implements OAuthTokenRefresher {
    @Override
    @NotNull
    public OAuthTokens refreshTokens(@NotNull ClientConnection connection, @NotNull String refreshToken) {
        return Converter.toSlingOAuthTokens(OAuthTokenRefresherImpl.refreshTokensInternal(connection, refreshToken));
    }

    @NotNull
    private static Tokens refreshTokensInternal(@NotNull ClientConnection connection, @NotNull String refreshTokenString) throws OAuthException {
        try {
            RefreshToken refreshToken = new RefreshToken(refreshTokenString);
            RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
            ResolvedConnection conn = ResolvedOAuthConnection.resolve(connection);
            ClientID clientID = new ClientID(conn.clientId());
            Secret clientSecret = new Secret(conn.clientSecret());
            ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
            URI tokenEndpoint = URI.create(conn.tokenEndpoint());
            TokenRequest request = new TokenRequest.Builder(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)refreshTokenGrant).build();
            AccessTokenResponse response = AccessTokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
            if (!response.indicatesSuccess()) {
                TokenErrorResponse errorResponse = response.toErrorResponse();
                throw new OAuthException("Failed refreshing the access token " + errorResponse.getErrorObject().getCode() + " : " + errorResponse.getErrorObject().getDescription());
            }
            AccessTokenResponse successResponse = response.toSuccessResponse();
            return successResponse.getTokens();
        }
        catch (ParseException | IOException e) {
            throw new OAuthException(e);
        }
    }
}

