/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.oak.internal;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name="Apache Sling Clam Node Observing JCR Property Digger", description="Observes the node store and adds scan jobs for matching JCR properties")
@interface NodeObservingJcrPropertyDiggerConfiguration {
    @AttributeDefinition(name="property type", description="Type of properties", options={@Option(label="Binary", value="Binary"), @Option(label="String", value="String")})
    public String property_type() default "Binary";

    @AttributeDefinition(name="property path pattern", description="Pattern a property path has to match, e.g. '^/content/.*/jcr:content/jcr:data$'")
    public String property_path_pattern() default "^/.*$";

    @AttributeDefinition(name="property length max", description="Max length of property value, -1 for unlimited length. Scanning data greater 4GB may result in errors due to limitations in Clam.")
    public long property_length_max() default -1L;

    @AttributeDefinition(name="threadpool name", description="Name of the ThreadPool to use for digging")
    public String threadpool_name() default "default";

    public String webconsole_configurationFactory_nameHint() default "{property.type}:{property.path.pattern}";
}

