/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.internal.ResourceEditorAssociationConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={ResourceEditorAssociation.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=ResourceEditorAssociationConfig.class, factory=true)
public class ResourceEditorAssociation {
    private Pattern pathPattern;
    private String editor;
    private String resourceType;
    private String parentType;

    @Activate
    public void activate(ResourceEditorAssociationConfig config) {
        this.pathPattern = Pattern.compile(config.pathPattern());
        this.editor = config.editor();
        this.resourceType = config.resourceType();
        this.parentType = config.parentType();
    }

    public boolean matches(Resource resource) {
        if (StringUtils.isNotBlank((CharSequence)this.parentType) && !this.hasParentType(resource)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.resourceType) && !this.resourceType.equals(resource.getResourceType())) {
            return false;
        }
        return this.pathPattern.matcher(resource.getPath()).matches();
    }

    private boolean hasParentType(Resource resource) {
        Resource parent = resource.getParent();
        if (parent != null && !parent.getResourceType().equals(this.parentType)) {
            return this.hasParentType(parent);
        }
        return parent != null && parent.getResourceType().equals(this.parentType);
    }

    public String getEditor() {
        return this.editor;
    }

    public String toString() {
        return "ResourceEditorAssociation [pathPattern=" + this.pathPattern + ", editor=" + this.editor + ", resourceType=" + this.resourceType + ", parentType=" + this.parentType + "]";
    }
}

