/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.ComponentPolicy;
import org.apache.sling.cms.core.internal.models.PageManagerImpl;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={ComponentPolicy.class})
public class ComponentPolicyImpl
implements ComponentPolicy {
    private static final Logger log = LoggerFactory.getLogger(ComponentPolicyImpl.class);
    @ValueMapValue
    private String pathPattern;
    @ValueMapValue
    private String policyPath;
    private final ResourceResolver resolver;

    public ComponentPolicyImpl(Resource resource) {
        this.resolver = resource.getResourceResolver();
        log.debug("Initialized policy {} with pattern {} and path {}", new Object[]{this.resolver, this.pathPattern, this.policyPath});
    }

    public boolean applies(Resource resource) {
        return Optional.ofNullable(new PageManagerImpl(resource).getPage()).map(p -> StringUtils.removeStart((String)resource.getPath(), (String)p.getPath())).map(p -> p.matches(this.pathPattern)).orElse(false);
    }

    public String[] getAvailableComponentTypes() {
        return this.getPolicyResource().map(pr -> (String[])pr.getValueMap().get("availableComponentTypes", (Object)new String[0])).orElse(new String[0]);
    }

    public Map<String, Resource> getComponentConfigs() {
        HashMap<String, Resource> configs = new HashMap<String, Resource>();
        Resource container = this.getPolicyResource().map(pr -> pr.getChild("componentConfigurations")).orElse(null);
        if (container != null) {
            container.getChildren().forEach(c -> configs.put((String)c.getValueMap().get("type", String.class), (Resource)c));
        }
        log.debug("Loaded configurations for components: {}", configs.keySet());
        return configs;
    }

    private Optional<Resource> getPolicyResource() {
        return Optional.ofNullable(this.resolver.getResource(this.policyPath));
    }

    public String toString() {
        return "ComponentPolicyImpl [pathPattern=" + this.pathPattern + ", policyPath=" + this.policyPath + ", resolver=" + this.resolver + ", policyResource=" + this.getPolicyResource() + "]";
    }
}

