/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.Component;
import org.apache.sling.cms.EditableResource;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class}, adapters={EditableResource.class})
public class EditableResourceImpl
implements EditableResource {
    private final Resource resource;

    public EditableResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public Component getComponent() {
        if (this.getComponentResource() != null) {
            return (Component)this.getComponentResource().adaptTo(Component.class);
        }
        return null;
    }

    public Resource getComponentResource() {
        String resourceType = this.resource.getResourceType();
        return this.resource.getResourceResolver().getResource(resourceType);
    }

    public String getEditPath() {
        if (this.getComponent() != null) {
            return this.getComponent().getEditPath();
        }
        return null;
    }

    public Resource getEditResource() {
        if (this.getComponent() != null) {
            return this.getComponent().getEditResource();
        }
        return null;
    }

    public Resource getResource() {
        return this.resource;
    }
}

