/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Calendar;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.apache.sling.cms.publication.PublicationType;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={PublishableResource.class})
public class PublishableResourceImpl
implements PublishableResource {
    private static final Logger log = LoggerFactory.getLogger(PublishableResourceImpl.class);
    public static final String LEGACY_PUBLISHED_PROPERTY = "published";
    private final Resource contentResource;
    private final Calendar created;
    private final String createdBy;
    private final Calendar lastModified;
    private final String lastModifiedBy;
    private final Calendar lastPublication;
    private final String lastPublicationType;
    private final boolean published;
    protected final Resource resource;
    private String lastPublicationBy;

    @Inject
    public PublishableResourceImpl(@Self Resource resource) {
        this.resource = resource;
        this.created = (Calendar)resource.getValueMap().get("jcr:created", Calendar.class);
        this.createdBy = (String)resource.getValueMap().get("jcr:createdBy", String.class);
        this.contentResource = "sling:Config".equals(resource.getValueMap().get("jcr:primaryType", String.class)) ? resource : resource.getChild("jcr:content");
        if (this.contentResource != null) {
            ValueMap properties = this.contentResource.getValueMap();
            this.lastModified = (Calendar)properties.get("jcr:lastModified", Calendar.class);
            this.lastModifiedBy = (String)properties.get("jcr:lastModifiedBy", String.class);
            this.lastPublication = (Calendar)properties.get("sling:lastPublication", Calendar.class);
            this.lastPublicationBy = (String)properties.get("jcr:lastModifiedBy", String.class);
            this.lastPublicationType = (String)properties.get("sling:lastPublicationType", String.class);
            this.published = (Boolean)properties.get("sling:published", (Object)((Boolean)properties.get(LEGACY_PUBLISHED_PROPERTY, (Object)false)));
        } else {
            this.lastModified = null;
            this.lastModifiedBy = null;
            this.lastPublication = null;
            this.lastPublicationBy = null;
            this.lastPublicationType = null;
            this.published = false;
        }
    }

    public Resource getContentResource() {
        return this.contentResource;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Calendar getLastModified() {
        return this.lastModified != null ? this.lastModified : this.created;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy != null ? this.lastModifiedBy : this.createdBy;
    }

    public PublicationType getLastPublicationType() {
        if (this.lastPublicationType != null) {
            try {
                return PublicationType.valueOf((String)this.lastPublicationType);
            }
            catch (IllegalArgumentException iae) {
                log.warn("Invalid publication type: {}", (Object)this.lastPublicationType, (Object)iae);
            }
        }
        return null;
    }

    public Calendar getLastPublication() {
        return this.lastPublication;
    }

    public String getLastPublicationBy() {
        return this.lastPublicationBy;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Resource getParent() {
        return this.resource.getParent();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ValueMap getProperties() {
        return this.getContentResource().getValueMap();
    }

    public String getPublishedPath() {
        Site site = this.getSite();
        if (site != null) {
            return this.resource.getPath().replace(site.getPath(), "");
        }
        return this.resource.getPath();
    }

    public String getPublishedUrl() {
        Site site = this.getSite();
        if (site != null) {
            return site.getUrl() + this.getPublishedPath();
        }
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Site getSite() {
        SiteManager siteMgr = (SiteManager)this.resource.adaptTo(SiteManager.class);
        Site site = null;
        if (siteMgr != null) {
            site = siteMgr.getSite();
        }
        return site;
    }

    public boolean isPublished() {
        return this.published;
    }
}

