/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.cms.NameFilter;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={NodeNameGenerator.class, NameFilter.class}, immediate=true)
@Designate(ocd=Config.class)
public class PropertyHintNodeNameGenerator
implements NodeNameGenerator,
NameFilter {
    public static final String RP_NODE_NAME_PARAM = ":nameParam";
    private String allowedChars;
    private char replacementChar;

    @Activate
    @Modified
    public void activate(Config config) {
        this.allowedChars = config.allowed_chars();
        this.replacementChar = config.replacement_char().toCharArray()[0];
    }

    public String filter(String nodeName) {
        StringBuilder sb = new StringBuilder();
        char lastAdded = '\u0000';
        nodeName = nodeName.toLowerCase();
        for (int i = 0; i < nodeName.length(); ++i) {
            char c;
            char toAdd = c = nodeName.charAt(i);
            if (this.allowedChars.indexOf(c) < 0) {
                if (lastAdded == this.replacementChar) continue;
                toAdd = this.replacementChar;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append(this.replacementChar);
            }
            sb.append(toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append(this.replacementChar);
        }
        return sb.toString();
    }

    public String getNodeName(SlingHttpServletRequest request, String parentPath, boolean requirePrefix, NodeNameGenerator defaultNodeNameGenerator) {
        RequestParameterMap parameters = request.getRequestParameterMap();
        String name = null;
        RequestParameter nameParam = null;
        RequestParameter paramName = parameters.getValue(RP_NODE_NAME_PARAM);
        if (paramName != null && StringUtils.isNotBlank((CharSequence)paramName.getString())) {
            nameParam = parameters.getValue(paramName.getString());
        }
        if (nameParam != null && StringUtils.isNotBlank((CharSequence)nameParam.getString())) {
            name = this.filter(nameParam.getString());
        }
        return name;
    }

    @ObjectClassDefinition(name="%cms.name.generator.name", description="%cms.name.generator.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%allowed.chars.name", description="%allowed.chars.description")
        public String allowed_chars() default "abcdefghijklmnopqrstuvwxyz0123456789_-";

        @AttributeDefinition(name="%replacement.char.name", description="%replacement.char.description")
        public String replacement_char() default "-";
    }
}

