/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Calendar;
import java.util.Collections;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class})
public class ResetPasswordAction
implements FormAction {
    public static final String RESOURCE_TYPE = "reference/components/forms/actions/resetpassword";
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordAction.class);
    private ResourceResolverFactory factory;

    @Activate
    public ResetPasswordAction(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        String email = (String)request.getFormData().get("email", String.class);
        String resetToken = (String)request.getFormData().get("resettoken", String.class);
        String password = (String)request.getFormData().get("password", String.class);
        try (ResourceResolver adminResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "slingcms-reference-usermanager"));){
            JackrabbitSession session = (JackrabbitSession)adminResolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            User user = (User)userManager.getAuthorizable(email);
            if (user == null) {
                FormActionResult formActionResult = FormActionResult.failure("No user found for " + email);
                return formActionResult;
            }
            String storedToken = this.getValue(user.getProperty("resettoken"), String.class);
            Calendar resetTimeout = this.getValue(user.getProperty("resettimeout"), Calendar.class);
            if (storedToken == null || !storedToken.equals(resetToken)) {
                FormActionResult formActionResult = FormActionResult.failure("Failed to validate token");
                return formActionResult;
            }
            if (Calendar.getInstance().after(resetTimeout)) {
                FormActionResult formActionResult = FormActionResult.failure("Timeout already passed");
                return formActionResult;
            }
            user.changePassword(password);
            log.debug("Saving changes!");
            adminResolver.commit();
            FormActionResult formActionResult = FormActionResult.success("Password reset successfully!");
            return formActionResult;
        }
        catch (Exception e) {
            throw new FormException("Failed to complete password reset", e);
        }
    }

    private <E> E getValue(Value[] property, Class<E> clazz) throws IllegalStateException, RepositoryException {
        if (property != null && property.length > 0) {
            Value v = property[0];
            if (clazz.isAssignableFrom(String.class)) {
                return clazz.cast(v.getString());
            }
            if (clazz.isAssignableFrom(Calendar.class)) {
                return clazz.cast(v.getDate());
            }
        }
        return null;
    }

    @Override
    public boolean handles(Resource actionResource) {
        return RESOURCE_TYPE.equals(actionResource.getResourceType());
    }
}

