/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.EnsureExceptionHandling;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import java.util.Map;

public class MaskingMessageUtil {
    private MaskingMessageUtil() {
    }

    public static void setMessageConverter(PatternLayout pl) {
        Map instanceConverterMap = pl.getInstanceConverterMap();
        instanceConverterMap.put("m", MaskingMessageConverter::new);
        instanceConverterMap.put("msg", MaskingMessageConverter::new);
        instanceConverterMap.put("message", MaskingMessageConverter::new);
        instanceConverterMap.put("ex", MaskingThrowableProxyConverter::new);
        instanceConverterMap.put("exception", MaskingThrowableProxyConverter::new);
        instanceConverterMap.put("rEx", MaskingRootCauseFirstThrowableProxyConverter::new);
        instanceConverterMap.put("rootException", MaskingRootCauseFirstThrowableProxyConverter::new);
        instanceConverterMap.put("throwable", MaskingThrowableProxyConverter::new);
        instanceConverterMap.put("xEx", MaskingExtendedThrowableProxyConverter::new);
        instanceConverterMap.put("xException", MaskingExtendedThrowableProxyConverter::new);
        instanceConverterMap.put("xThrowable", MaskingExtendedThrowableProxyConverter::new);
        pl.setPostCompileProcessor((PostCompileProcessor)new MaskingEnsureExceptionHandling());
    }

    public static Encoder<ILoggingEvent> getDefaultEncoder(Context loggerContext) {
        MaskingPatternLayoutEncoder encoder = new MaskingPatternLayoutEncoder();
        encoder.setPattern("%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n");
        encoder.setContext(loggerContext);
        encoder.start();
        return encoder;
    }

    static String mask(String msg) {
        if (msg == null) {
            return null;
        }
        return msg.replace('\n', '_').replace('\r', '_');
    }

    static final class MaskingEnsureExceptionHandling
    extends EnsureExceptionHandling {
        MaskingEnsureExceptionHandling() {
        }

        public void process(Context context, Converter<ILoggingEvent> head) {
            if (head == null) {
                throw new IllegalArgumentException("cannot process empty chain");
            }
            if (!this.chainHandlesThrowable(head)) {
                Converter tail = ConverterUtil.findTail(head);
                Object exConverter = null;
                LoggerContext loggerContext = (LoggerContext)context;
                exConverter = loggerContext.isPackagingDataEnabled() ? new MaskingExtendedThrowableProxyConverter() : new MaskingThrowableProxyConverter();
                tail.setNext((Converter)exConverter);
            }
        }
    }

    static final class MaskingPatternLayoutEncoder
    extends PatternLayoutEncoderBase<ILoggingEvent> {
        MaskingPatternLayoutEncoder() {
        }

        public void start() {
            PatternLayout patternLayout = new PatternLayout();
            patternLayout.setContext(this.context);
            patternLayout.setPattern(this.getPattern());
            patternLayout.setOutputPatternAsHeader(this.outputPatternAsHeader);
            MaskingMessageUtil.setMessageConverter(patternLayout);
            patternLayout.start();
            this.layout = patternLayout;
            super.start();
        }
    }

    public static final class MaskingThrowableProxy
    implements IThrowableProxy {
        private final IThrowableProxy proxied;

        public MaskingThrowableProxy(IThrowableProxy proxied) {
            this.proxied = proxied;
        }

        public String getMessage() {
            return MaskingMessageUtil.mask(this.proxied.getMessage());
        }

        private IThrowableProxy getProxy(IThrowableProxy p) {
            if (p == null) {
                return null;
            }
            if (p == this.proxied || p == this) {
                return this;
            }
            return new MaskingThrowableProxy(p);
        }

        public IThrowableProxy getCause() {
            return this.getProxy(this.proxied.getCause());
        }

        public String getClassName() {
            return this.proxied.getClassName();
        }

        public StackTraceElementProxy[] getStackTraceElementProxyArray() {
            return this.proxied.getStackTraceElementProxyArray();
        }

        public int getCommonFrames() {
            return this.proxied.getCommonFrames();
        }

        public IThrowableProxy[] getSuppressed() {
            IThrowableProxy[] result = this.proxied.getSuppressed();
            if (result == null || result.length == 0) {
                return result;
            }
            IThrowableProxy[] proxies = new IThrowableProxy[result.length];
            for (int i = 0; i < proxies.length; ++i) {
                proxies[i] = this.getProxy(result[i]);
            }
            return proxies;
        }

        public boolean isCyclic() {
            return this.proxied.isCyclic();
        }
    }

    public static class MaskingExtendedThrowableProxyConverter
    extends ExtendedThrowableProxyConverter {
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString((IThrowableProxy)new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingRootCauseFirstThrowableProxyConverter
    extends RootCauseFirstThrowableProxyConverter {
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString((IThrowableProxy)new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingThrowableProxyConverter
    extends ThrowableProxyConverter {
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString((IThrowableProxy)new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingMessageConverter
    extends MessageConverter {
        public String convert(ILoggingEvent event) {
            return MaskingMessageUtil.mask(super.convert(event));
        }
    }
}

