/*
 * Decompiled with CFR 0.152.
 */
package com.tomgibara.crinch.hashing;

import com.tomgibara.crinch.hashing.Hash;
import com.tomgibara.crinch.hashing.HashRange;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

public class PerfectStringHash
implements Hash<String> {
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int h2;
            int h1 = s1.hashCode();
            if (h1 == (h2 = s2.hashCode())) {
                int d = s1.length() - s2.length();
                return d == 0 ? s1.compareTo(s2) : d;
            }
            return h1 < h2 ? -1 : 1;
        }
    };
    private final int[] hashes;
    private final int[] offsets;
    private final int[] pivots;
    private final HashRange range;

    private static void generatePivots(String[] values, int start, int length, int[] pivots, int pivotIndex) {
        int depth;
        int capacity = Integer.highestOneBit(length - 1) << 1;
        pivots[pivotIndex << 1] = depth = Integer.numberOfTrailingZeros(capacity);
        pivots[(pivotIndex << 1) + 1] = length;
        ++pivotIndex;
        for (int i = 0; i < depth; ++i) {
            int step = capacity >> i;
            for (int j = (1 << depth - i - 1) - 1; j < capacity; j += step) {
                int comp;
                int part;
                if (j >= length - 1) {
                    part = Integer.MIN_VALUE;
                    comp = 0;
                } else {
                    int l2;
                    String v1 = values[start + j];
                    String v2 = values[start + j + 1];
                    int l1 = v1.length();
                    if (l1 == (l2 = v2.length())) {
                        int tPart = -1;
                        int tComp = -1;
                        for (int k = 0; k < l1; ++k) {
                            char c2;
                            char c1 = v1.charAt(k);
                            if (c1 == (c2 = v2.charAt(k))) continue;
                            if (c1 < c2) {
                                tPart = k;
                                tComp = c1;
                                break;
                            }
                            throw new IllegalStateException();
                        }
                        if (tPart == -1) {
                            throw new IllegalArgumentException("duplicate value: " + v1);
                        }
                        part = tPart;
                        comp = tComp;
                    } else {
                        part = -1;
                        comp = l1;
                    }
                }
                pivots[pivotIndex << 1] = part;
                pivots[(pivotIndex << 1) + 1] = comp;
                ++pivotIndex;
            }
        }
    }

    public PerfectStringHash(String[] values) {
        int runLength;
        int length = values.length;
        if (length == 0) {
            throw new IllegalArgumentException("No values supplied");
        }
        int[] hashes = new int[length];
        int[] offsets = new int[2 * length];
        int[] runLengths = new int[length];
        Arrays.sort(values, comparator);
        for (int i = 0; i < length; ++i) {
            hashes[i] = values[i].hashCode();
        }
        int offset = 0;
        if (length > 1) {
            int previousHash = hashes[0];
            int runLength2 = 1;
            for (int i = 1; i <= length; ++i) {
                int currentHash;
                int n = currentHash = i == length ? ~previousHash : hashes[i];
                if (currentHash == previousHash) {
                    ++runLength2;
                } else if (runLength2 > 1) {
                    int firstIndex = i - runLength2;
                    for (int j = i - 1; j >= firstIndex; --j) {
                        runLengths[j] = runLength2;
                        offsets[j << 1] = offset;
                        offsets[(j << 1) + 1] = j - firstIndex;
                    }
                    offset += Integer.highestOneBit(runLength2 - 1) << 1;
                    runLength2 = 1;
                } else {
                    runLengths[i - 1] = 1;
                    offsets[i - 1 << 1] = -1;
                }
                previousHash = currentHash;
            }
        }
        if (offset == 0) {
            this.hashes = hashes;
            this.offsets = null;
            this.pivots = null;
            this.range = new HashRange(0, length - 1);
            return;
        }
        int[] pivots = new int[offset * 2];
        for (int i = 0; i < length; i += runLength) {
            runLength = runLengths[i];
            if (runLength <= 1) continue;
            PerfectStringHash.generatePivots(values, i, runLength, pivots, offsets[i << 1]);
        }
        this.pivots = pivots;
        this.offsets = offsets;
        this.hashes = hashes;
        this.range = new HashRange(0, length - 1);
    }

    @Override
    public HashRange getRange() {
        return this.range;
    }

    @Override
    public BigInteger hashAsBigInt(String value) {
        return BigInteger.valueOf(this.hash(value));
    }

    @Override
    public int hashAsInt(String value) {
        return this.hash(value);
    }

    @Override
    public long hashAsLong(String value) {
        return this.hash(value);
    }

    private int hash(String value) {
        int h = value.hashCode();
        int index = Arrays.binarySearch(this.hashes, h);
        int[] pivots = this.pivots;
        if (pivots == null || index < 0) {
            return index;
        }
        int offset = this.offsets[index << 1];
        if (offset == -1) {
            return index;
        }
        int depth = pivots[offset << 1];
        int count = pivots[(offset << 1) + 1];
        int i = 0;
        for (int d = 0; d < depth; ++d) {
            int t = offset + (1 << d) + i << 1;
            int part = pivots[t];
            int comp = pivots[t + 1];
            boolean right = part == Integer.MIN_VALUE ? false : (part == -1 ? value.length() > comp : value.charAt(part) > (char)comp);
            i <<= 1;
            if (!right) continue;
            ++i;
        }
        return i >= count ? -1 : index + i - this.offsets[(index << 1) + 1];
    }
}

