/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.core.CrankstartParserImpl;
import org.apache.sling.crankstart.core.ParserException;

class CmdIterator
implements Iterator<CrankstartCommandLine> {
    private static final char ESCAPE = '$';
    private String line;
    private final BufferedReader input;
    private final CrankstartParserImpl parser;
    private final Pattern varPattern = Pattern.compile("\\$\\{([a-zA-Z0-9\\._]+)\\}");

    CmdIterator(Reader r, CrankstartParserImpl parser) throws IOException {
        this.input = new BufferedReader(r);
        this.parser = parser;
        this.takeLine();
    }

    private String takeLine() throws IOException {
        String result = this.line;
        this.line = this.input.readLine();
        while (this.line != null && this.ignore(this.line)) {
            this.line = this.input.readLine();
        }
        return this.injectVariables(result);
    }

    private String injectVariables(String line) {
        if (line == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        Matcher m = this.varPattern.matcher(line);
        while (m.find()) {
            if (m.start() > 0 && line.charAt(m.start() - 1) != '$') {
                m.appendReplacement(b, Matcher.quoteReplacement(this.getValue(m.group(1))));
                continue;
            }
            m.appendReplacement(b, m.group().substring(1));
        }
        m.appendTail(b);
        return b.toString();
    }

    private String getValue(String variable) {
        return this.parser.getVariable(variable);
    }

    private boolean ignore(String line) {
        if (line == null) {
            return false;
        }
        return CmdIterator.empty(line = line.trim()) || line.startsWith("#");
    }

    private boolean isVerb() {
        return this.line != null && this.line.length() > 0 && !Character.isWhitespace(this.line.charAt(0));
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public CrankstartCommandLine next() {
        if (!this.isVerb()) {
            throw new ParserException("Expecting verb, current line is " + this.line);
        }
        CrankstartCommandLine result = null;
        try {
            String[] firstLine = this.takeLine().split(" ");
            String verb = firstLine[0];
            StringBuilder qualifier = new StringBuilder();
            for (int i = 1; i < firstLine.length; ++i) {
                if (qualifier.length() > 0) {
                    qualifier.append(' ');
                }
                qualifier.append(firstLine[i]);
            }
            Hashtable<String, Object> props = null;
            while (this.line != null && !this.isVerb()) {
                if (props == null) {
                    props = new Hashtable<String, Object>();
                }
                this.addProperty(props, this.takeLine());
            }
            result = new CrankstartCommandLine(verb, qualifier.toString(), props);
        }
        catch (IOException ioe) {
            this.line = null;
            throw new ParserException("IOException in takeLine()", ioe);
        }
        return result;
    }

    private static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private void addProperty(Dictionary<String, Object> props, String line) throws ParserException {
        if (line == null) {
            return;
        }
        int equalsPos = line.indexOf(61);
        String key = line.substring(0, equalsPos).trim();
        String value = line.substring(equalsPos + 1).trim();
        if (CmdIterator.empty(key) || CmdIterator.empty(value)) {
            throw new ParserException("Invalid property line [" + line + "]");
        }
        Object o = props.get(key);
        if (o == null) {
            props.put(key, value);
        } else if (o instanceof String[]) {
            String[] a = (String[])o;
            a = Arrays.copyOf(a, a.length + 1);
            a[a.length - 1] = value;
            props.put(key, a);
        } else {
            String[] a = new String[]{(String)o, value};
            props.put(key, a);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

