/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exit
implements CrankstartCommand {
    public static final String I_EXIT = "exit.iftrue";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_EXIT.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "exit.iftrue: exit if the command qualifier is 'true'";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        if (Boolean.valueOf(commandLine.getQualifier()).booleanValue()) {
            this.log.info("Qualifier is true, OSGi framework will be stopped");
            crankstartContext.setAttribute("stop.osgi.framework", (Object)true);
        }
    }
}

