/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.distribution.journal.impl.subscriber.IdleCheck;

public class SubscriberIdle
implements IdleCheck {
    public static final int DEFAULT_IDLE_TIME_MILLIS = 10000;
    public static final int DEFAULT_FORCE_IDLE_MILLIS = 300000;
    public static final int MAX_RETRIES = 10;
    private final int idleMillis;
    private final AtomicBoolean isReady;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> schedule;

    public SubscriberIdle(int idleMillis, int forceIdleMillies, AtomicBoolean readyHolder) {
        this.idleMillis = idleMillis;
        this.isReady = readyHolder;
        this.executor = Executors.newScheduledThreadPool(2);
        this.executor.schedule(this::forceIdle, (long)forceIdleMillies, TimeUnit.MILLISECONDS);
        this.idle();
    }

    @Override
    public boolean isIdle() {
        return this.isReady.get();
    }

    @Override
    public synchronized void busy(int retries) {
        this.cancelSchedule();
        if (retries > 10) {
            this.ready();
        }
    }

    @Override
    public synchronized void idle() {
        if (!this.isReady.get()) {
            this.cancelSchedule();
            if (!this.executor.isShutdown()) {
                this.schedule = this.executor.schedule(this::ready, (long)this.idleMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void forceIdle() {
        this.isReady.set(true);
        this.cancelSchedule();
    }

    private void cancelSchedule() {
        if (this.schedule != null) {
            this.schedule.cancel(false);
        }
    }

    private void ready() {
        this.isReady.set(true);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

