/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Histogram;
import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.distribution.journal.metrics.Tag;
import org.apache.sling.distribution.journal.metrics.TaggedMetrics;

public class PublishMetrics {
    private static final String TAG_AGENT_NAME = "pub_name";
    public static final String PUB_COMPONENT = "distribution.journal.publisher.";
    private static final String EXPORTED_PACKAGE_SIZE = "distribution.journal.publisher.exported_package_size";
    private static final String ACCEPTED_REQUESTS = "distribution.journal.publisher.accepted_requests";
    private static final String DROPPED_REQUESTS = "distribution.journal.publisher.dropped_requests";
    private static final String BUILD_PACKAGE_DURATION = "distribution.journal.publisher.build_package_duration";
    private static final String ENQUEUE_PACKAGE_DURATION = "distribution.journal.publisher.enqueue_package_duration";
    private static final String QUEUE_CACHE_FETCH_COUNT = "distribution.journal.publisher.queue_cache_fetch_count";
    private static final String QUEUE_ACCESS_ERROR_COUNT = "distribution.journal.publisher.queue_access_error_count";
    private static final String SUBSCRIBER_COUNT = "distribution.journal.publisher.subscriber_count";
    private static final String QUEUE_SIZE = "distribution.journal.publisher.queue_size";
    private final List<Tag> tags;
    private final MetricsService metricsService;

    public PublishMetrics(MetricsService metricsService, String pubAgentName) {
        this.tags = Arrays.asList(Tag.of(TAG_AGENT_NAME, pubAgentName));
        this.metricsService = metricsService;
    }

    public Histogram getExportedPackageSize() {
        return this.metricsService.histogram(TaggedMetrics.getMetricName(EXPORTED_PACKAGE_SIZE, this.tags));
    }

    public Meter getAcceptedRequests() {
        return this.metricsService.meter(TaggedMetrics.getMetricName(ACCEPTED_REQUESTS, this.tags));
    }

    public Meter getDroppedRequests() {
        return this.metricsService.meter(TaggedMetrics.getMetricName(DROPPED_REQUESTS, this.tags));
    }

    public Timer getBuildPackageDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(BUILD_PACKAGE_DURATION, this.tags));
    }

    public Timer getEnqueuePackageDuration() {
        return this.metricsService.timer(TaggedMetrics.getMetricName(ENQUEUE_PACKAGE_DURATION, this.tags));
    }

    public Counter getQueueCacheFetchCount() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(QUEUE_CACHE_FETCH_COUNT, this.tags));
    }

    public Counter getQueueAccessErrorCount() {
        return this.metricsService.counter(TaggedMetrics.getMetricName(QUEUE_ACCESS_ERROR_COUNT, this.tags));
    }

    public void subscriberCount(Supplier<Integer> subscriberCountCallback) {
        this.metricsService.gauge(TaggedMetrics.getMetricName(SUBSCRIBER_COUNT, this.tags), subscriberCountCallback);
    }

    public void queueSize(Supplier<Integer> queueSizeCallback) {
        this.metricsService.gauge(TaggedMetrics.getMetricName(QUEUE_SIZE, this.tags), queueSizeCallback);
    }
}

