/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format;

import io.wcm.handler.media.format.MediaFormat;
import io.wcm.sling.commons.resource.ImmutableValueMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaFormatBuilder {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-\\_]+$");
    private final String name;
    private String label;
    private String description;
    private long width;
    private long minWidth;
    private long maxWidth;
    private long height;
    private long minHeight;
    private long maxHeight;
    private double ratio;
    private double ratioWidth;
    private double ratioHeight;
    private long fileSizeMax;
    private String[] extensions;
    private String renditionGroup;
    private boolean download;
    private boolean internal;
    private int ranking;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    private MediaFormatBuilder(String name) {
        if (name == null || !NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        this.name = name;
    }

    @NotNull
    public static MediaFormatBuilder create(@NotNull String name) {
        return new MediaFormatBuilder(name);
    }

    @NotNull
    public MediaFormatBuilder label(String value) {
        this.label = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder description(String value) {
        this.description = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder width(long value) {
        this.width = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder minWidth(long value) {
        this.minWidth = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder maxWidth(long value) {
        this.maxWidth = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder width(long min, long max) {
        this.minWidth = min;
        this.maxWidth = max;
        return this;
    }

    @NotNull
    public MediaFormatBuilder height(long value) {
        this.height = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder minHeight(long value) {
        this.minHeight = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder maxHeight(long value) {
        this.maxHeight = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder height(long min, long max) {
        this.minHeight = min;
        this.maxHeight = max;
        return this;
    }

    @NotNull
    public MediaFormatBuilder fixedDimension(long widthValue, long heightValue) {
        this.width = widthValue;
        this.height = heightValue;
        return this;
    }

    @NotNull
    public MediaFormatBuilder ratio(double value) {
        this.ratio = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder ratio(long widthValue, long heightValue) {
        this.ratioWidth = widthValue;
        this.ratioHeight = heightValue;
        return this;
    }

    @NotNull
    public MediaFormatBuilder ratio(double widthValue, double heightValue) {
        this.ratioWidth = widthValue;
        this.ratioHeight = heightValue;
        return this;
    }

    @NotNull
    public MediaFormatBuilder fileSizeMax(long value) {
        this.fileSizeMax = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder extensions(String ... value) {
        this.extensions = value != null ? (String[])value.clone() : null;
        return this;
    }

    @NotNull
    public MediaFormatBuilder renditionGroup(String value) {
        this.renditionGroup = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder download(boolean value) {
        this.download = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder internal(boolean value) {
        this.internal = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder ranking(int value) {
        this.ranking = value;
        return this;
    }

    @NotNull
    public MediaFormatBuilder properties(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map argument must not be null.");
        }
        this.properties.putAll(map);
        return this;
    }

    @NotNull
    public MediaFormatBuilder property(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key argument must not be null.");
        }
        this.properties.put(key, value);
        return this;
    }

    @NotNull
    public MediaFormat build() {
        if (this.name == null) {
            throw new IllegalArgumentException("Name is missing.");
        }
        return new MediaFormat(this.name, this.label, this.description, this.width, this.minWidth, this.maxWidth, this.height, this.minHeight, this.maxHeight, this.ratio, this.ratioWidth, this.ratioHeight, this.fileSizeMax, MediaFormatBuilder.nonNullArray(this.extensions), this.renditionGroup, this.download, this.internal, this.ranking, (ValueMap)ImmutableValueMap.copyOf(this.properties));
    }

    private static String[] nonNullArray(String[] value) {
        if (value == null) {
            return new String[0];
        }
        return value;
    }
}

