/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DamAutoCropping {
    private final Asset asset;
    private final MediaArgs mediaArgs;

    DamAutoCropping(@NotNull Asset asset, @NotNull MediaArgs mediaArgs) {
        this.asset = asset;
        this.mediaArgs = mediaArgs;
    }

    public List<CropDimension> calculateAutoCropDimensions() {
        Stream<MediaFormat> mediaFormats = Arrays.stream((MediaFormat[])ObjectUtils.defaultIfNull((Object)this.mediaArgs.getMediaFormats(), (Object)new MediaFormat[0]));
        return mediaFormats.map(this::calculateAutoCropDimension).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private CropDimension calculateAutoCropDimension(@NotNull MediaFormat mediaFormat) {
        RenditionMetadata rendition;
        double ratio = mediaFormat.getRatio();
        if (ratio > 0.0 && (rendition = DamAutoCropping.getWebRenditionForCropping(this.asset)) != null && rendition.getWidth() > 0L && rendition.getHeight() > 0L) {
            return ImageTransformation.calculateAutoCropDimension(rendition.getWidth(), rendition.getHeight(), ratio);
        }
        return null;
    }

    @Nullable
    public static RenditionMetadata getWebRenditionForCropping(@NotNull Asset asset) {
        return asset.getRenditions().stream().filter(AssetRendition::isWebRendition).findFirst().map(rendition -> new RenditionMetadata((Rendition)rendition)).orElse(null);
    }
}

