/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.json.JSONParserFeature;
import org.apache.sling.contentparser.json.JSONParserOptions;
import org.apache.sling.contentparser.json.internal.JSONContentParser;
import org.apache.sling.contentparser.xml.internal.XMLContentParser;
import org.apache.sling.contentparser.xml.jcr.internal.JCRXMLContentParser;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentElementHandler;
import org.apache.sling.fsprovider.internal.parser.ContentFileTypes;
import org.apache.sling.fsprovider.internal.parser.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentFileParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ContentFileParserUtil.class);
    private static final ParserOptions DEFAULT_PARSER_OPTIONS = new ParserOptions();
    private static final ParserOptions JSON_PARSER_OPTIONS = new JSONParserOptions().withFeatures(JSONParserFeature.COMMENTS, JSONParserFeature.QUOTE_TICK);
    private static final ContentParser JSON_PARSER = new JSONContentParser();
    private static final ContentParser JCR_XML_PARSER = new JCRXMLContentParser();
    private static final ContentParser XML_PARSER = new XMLContentParser();

    private ContentFileParserUtil() {
    }

    public static ContentElement parse(File file) {
        if (!file.exists()) {
            return null;
        }
        if (StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.JSON_SUFFIX)) {
            return ContentFileParserUtil.parse(file, ContentType.JSON);
        }
        if (StringUtils.equals((CharSequence)file.getName(), (CharSequence)".content.xml") || StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.JCR_XML_SUFFIX)) {
            return ContentFileParserUtil.parse(file, ContentType.JCR_XML);
        }
        if (StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.XML_SUFFIX) && !StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.JCR_XML_SUFFIX)) {
            return ContentFileParserUtil.parse(file, ContentType.XML);
        }
        return null;
    }

    public static ContentElement parse(File file, ContentType contentType) {
        if (!file.exists()) {
            return null;
        }
        try {
            switch (contentType) {
                case JSON: {
                    return ContentFileParserUtil.parse(JSON_PARSER, file, JSON_PARSER_OPTIONS);
                }
                case XML: {
                    return ContentFileParserUtil.parse(XML_PARSER, file, DEFAULT_PARSER_OPTIONS);
                }
                case JCR_XML: {
                    return ContentFileParserUtil.parse(JCR_XML_PARSER, file, DEFAULT_PARSER_OPTIONS);
                }
            }
            throw new IllegalArgumentException("Unexpected content type: " + (Object)((Object)contentType));
        }
        catch (Throwable ex) {
            log.warn("Error parsing content from " + file.getPath(), ex);
            return null;
        }
    }

    private static ContentElement parse(ContentParser contentParser, File file, ParserOptions parserOptions) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            ContentElement contentElement;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                ContentElementHandler handler = new ContentElementHandler();
                contentParser.parse(handler, bis, parserOptions);
                contentElement = handler.getRoot();
            }
            return contentElement;
        }
    }
}

