/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;

public class SubArchive
extends AbstractArchive {
    private Archive base;
    private Archive.Entry root;
    private final boolean isJcrRoot;
    private DefaultMetaInf inf = new DefaultMetaInf();

    public SubArchive(Archive base, Archive.Entry root, boolean isJcrRoot) {
        this.base = base;
        this.root = root;
        this.isJcrRoot = isJcrRoot;
        this.inf.setSettings(base.getMetaInf().getSettings());
        this.inf.setConfig(base.getMetaInf().getConfig());
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    @Override
    public Archive.Entry getJcrRoot() throws IOException {
        if (this.isJcrRoot) {
            return this.root;
        }
        return super.getJcrRoot();
    }

    @Override
    public void open(boolean strict) throws IOException {
    }

    @Override
    public MetaInf getMetaInf() {
        return this.inf;
    }

    @Override
    public void close() {
        this.base = null;
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.base.openInputStream(entry);
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return this.base.getInputSource(entry);
    }
}

