/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

abstract class ConfigUtil {
    public static final String PROPERTY_DELETE_MARKER = "org.apache.sling.installer.configuration.deleted";
    private static final String CONFIG_PATH_KEY = "org.apache.sling.installer.osgi.path";
    private static final String ALIAS_KEY = "org.apache.sling.installer.osgi.factoryaliaspid";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();

    ConfigUtil() {
    }

    private static Set<String> collectKeys(Dictionary<String, Object> a) {
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> aI = a.keys();
        while (aI.hasMoreElements()) {
            String key = aI.nextElement();
            if (IGNORED_PROPERTIES.contains(key)) continue;
            keys.add(key);
        }
        return keys;
    }

    private static Object[] convertToObjectArray(Object value) {
        Object[] values = new Object[Array.getLength(value)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Array.get(value, i);
        }
        return values;
    }

    public static boolean isSameData(Dictionary<String, Object> a, Dictionary<String, Object> b) {
        boolean result = false;
        if (a != null && b != null) {
            Set<String> keysA = ConfigUtil.collectKeys(a);
            Set<String> keysB = ConfigUtil.collectKeys(b);
            if (keysA.size() == keysB.size() && keysA.containsAll(keysB)) {
                result = true;
                for (String key : keysA) {
                    Object valB;
                    Object valA = a.get(key);
                    if (ConfigUtil.isSameValue(valA, valB = b.get(key))) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public static boolean isSameValue(Object valA, Object valB) {
        if (valA == null && valB == null) {
            return true;
        }
        if (valA == null || valB == null) {
            return false;
        }
        if (valA.getClass().isArray() && valB.getClass().isArray()) {
            Object[] arrB;
            Object[] arrA = ConfigUtil.convertToObjectArray(valA);
            if (arrA.length != (arrB = ConfigUtil.convertToObjectArray(valB)).length) {
                return false;
            }
            for (int i = 0; i < arrA.length; ++i) {
                if (String.valueOf(arrA[i]).equals(String.valueOf(arrB[i]))) continue;
                return false;
            }
        } else if (!valA.getClass().isArray() && !valB.getClass().isArray()) {
            if (!String.valueOf(valA).equals(String.valueOf(valB))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static Dictionary<String, Object> cleanConfiguration(Dictionary<String, Object> config) {
        Hashtable<String, Object> cleanedConfig = new Hashtable<String, Object>();
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (IGNORED_PROPERTIES.contains(key)) continue;
            ((Dictionary)cleanedConfig).put(key, config.get(key));
        }
        return cleanedConfig;
    }

    private static String encode(String value) {
        return value.replace("\\", "\\\\").replace("*", "\\*").replace("(", "\\(").replace(")", "\\)");
    }

    public static Configuration getConfiguration(ConfigurationAdmin ca, String factoryPid, String configPidOrName) throws IOException, InvalidSyntaxException {
        Configuration config = ConfigUtil.getOrCreateConfiguration(ca, factoryPid, configPidOrName, null, false);
        if (config == null && factoryPid != null) {
            config = ConfigUtil.getLegacyFactoryConfig(ca, factoryPid, null, configPidOrName);
        }
        return config;
    }

    public static Configuration createConfiguration(ConfigurationAdmin ca, String factoryPid, String configPidOrName, String location) throws IOException, InvalidSyntaxException {
        return ConfigUtil.getOrCreateConfiguration(ca, factoryPid, configPidOrName, location, true);
    }

    private static Configuration getOrCreateConfiguration(ConfigurationAdmin ca, String factoryPid, String configPidOrName, String location, boolean createIfNeeded) throws IOException, InvalidSyntaxException {
        Configuration result = null;
        if (factoryPid == null) {
            if (createIfNeeded) {
                result = ca.getConfiguration(configPidOrName, location);
            } else {
                String filter = "(service.pid=" + ConfigUtil.encode(configPidOrName) + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    result = configs[0];
                }
            }
        } else if (createIfNeeded) {
            result = ca.getFactoryConfiguration(factoryPid, configPidOrName, location);
        } else {
            String filter = "(&(service.factoryPid=" + ConfigUtil.encode(factoryPid) + ")(" + "service.pid" + "=" + ConfigUtil.encode(ConfigUtil.getPIDOfFactoryPID(factoryPid, configPidOrName)) + "))";
            Configuration[] configs = ca.listConfigurations(filter);
            if (configs != null && configs.length > 0) {
                result = configs[0];
            }
        }
        return result;
    }

    public static Configuration getLegacyFactoryConfig(ConfigurationAdmin ca, String factoryPid, String aliasPid, String pid) throws IOException, InvalidSyntaxException {
        String configPid = aliasPid != null ? aliasPid.substring(factoryPid.length() + 1) : pid;
        Configuration result = null;
        Configuration[] configs = null;
        if (configPid != null) {
            configs = ca.listConfigurations("(&(service.factoryPid=" + ConfigUtil.encode(factoryPid) + ")(" + "service.pid" + "=" + ConfigUtil.encode(configPid) + "))");
        }
        if (configs == null || configs.length == 0) {
            configs = ca.listConfigurations("(&(service.factoryPid=" + ConfigUtil.encode(factoryPid) + ")(" + "service.pid" + "=" + ConfigUtil.encode(factoryPid + "." + configPid) + "))");
        }
        if (configs == null || configs.length == 0) {
            configs = ca.listConfigurations("(&(service.factoryPid=" + factoryPid + ")(" + ALIAS_KEY + "=" + ConfigUtil.encode(configPid) + "))");
            if (configs != null && configs.length > 0) {
                result = configs[0];
            }
        } else {
            result = configs[0];
        }
        return result;
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        boolean result = defaultValue;
        if (obj != null) {
            result = obj instanceof Boolean ? ((Boolean)obj).booleanValue() : Boolean.valueOf(String.valueOf(obj)).booleanValue();
        }
        return result;
    }

    public static String getPIDOfFactoryPID(String factoryPID, String name) {
        return factoryPID.concat("~").concat(name);
    }

    public static Dictionary<String, Object> mergeReverseOrder(List<Dictionary<String, Object>> propertiesList) {
        Collections.reverse(propertiesList);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (Dictionary<String, Object> dict : propertiesList) {
            ConfigUtil.merge(properties, dict);
        }
        return properties;
    }

    private static void merge(Dictionary<String, Object> base, Dictionary<String, Object> props) {
        Enumeration<String> keyIter = props.keys();
        while (keyIter.hasMoreElements()) {
            String key = keyIter.nextElement();
            base.put(key, props.get(key));
        }
    }

    public static void removeRedundantProperties(Dictionary<String, Object> properties, Dictionary<String, Object> base) {
        Enumeration<String> keyEnum = base.keys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            Object value = base.get(key);
            Object newValue = properties.get(key);
            if (newValue == null || !ConfigUtil.isSameValue(newValue, value)) continue;
            properties.remove(key);
        }
    }

    static {
        IGNORED_PROPERTIES.add("service.pid");
        IGNORED_PROPERTIES.add(CONFIG_PATH_KEY);
        IGNORED_PROPERTIES.add(ALIAS_KEY);
        IGNORED_PROPERTIES.add("service.factoryPid");
    }
}

