/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.ide;

import java.io.ObjectInputStream;
import org.apache.http.HttpEntity;
import org.apache.sling.junit.remote.httpclient.RemoteTestHttpClient;
import org.apache.sling.junit.remote.ide.ExecutionResult;
import org.apache.sling.testing.tools.http.Request;
import org.apache.sling.testing.tools.http.RequestCustomizer;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRemoteExecutionRule
implements MethodRule,
RequestCustomizer {
    private static final Logger log = LoggerFactory.getLogger(SlingRemoteExecutionRule.class);
    public static final String SLING_REMOTE_TEST_URL = "sling.remote.test.url";
    public static final String SLING_REMOTE_TEST_USERNAME = "sling.remote.test.username";
    public static final String SLING_REMOTE_TEST_PASSWORD = "sling.remote.test.password";

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (SlingRemoteExecutionRule.this.tryRemoteEvaluation(method)) {
                    return;
                }
                base.evaluate();
            }
        };
    }

    private boolean tryRemoteEvaluation(FrameworkMethod method) throws Throwable {
        String remoteUrl = System.getProperty(SLING_REMOTE_TEST_URL);
        String remoteUsername = System.getProperty(SLING_REMOTE_TEST_USERNAME);
        String remotePassword = System.getProperty(SLING_REMOTE_TEST_PASSWORD);
        if (remoteUrl != null && (remoteUrl = remoteUrl.trim()).length() > 0) {
            this.invokeRemote(remoteUrl, remoteUsername, remotePassword, method);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRemote(String remoteUrl, String remoteUsername, String remotePassword, FrameworkMethod method) throws Throwable {
        String testClassesSelector = method.getMethod().getDeclaringClass().getName();
        String methodName = method.getMethod().getName();
        RemoteTestHttpClient testHttpClient = new RemoteTestHttpClient(remoteUrl, remoteUsername, remotePassword, false);
        testHttpClient.setRequestCustomizer(this);
        RequestExecutor executor = testHttpClient.runTests(testClassesSelector, methodName, "serialized");
        log.debug("Ran test {} method {} at URL {}", new Object[]{testClassesSelector, methodName, remoteUrl});
        HttpEntity entity = executor.getResponse().getEntity();
        if (entity != null) {
            try {
                Object o = new ObjectInputStream(entity.getContent()).readObject();
                if (!(o instanceof ExecutionResult)) {
                    throw new IllegalStateException("Expected an ExecutionResult, got a " + o.getClass().getName());
                }
                ExecutionResult result = (ExecutionResult)o;
                if (result.isFailure()) {
                    throw result.getException();
                }
            }
            finally {
                entity.consumeContent();
            }
        }
    }

    public void customizeRequest(Request r) {
    }
}

