/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.shared.dependency.analyzer.asm.DependencyClassFileVisitor;
import org.slf4j.Logger;

class DependencyAnalyzer {
    private final Class<?>[] classes;
    private final Set<String> dependencyNames = new HashSet<String>();
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private final Set<Class<?>> alreadySeen = new HashSet();
    private Collection<Class<?>> dependencies;

    private DependencyAnalyzer(Class<?> ... classes) {
        this.classes = classes;
    }

    static DependencyAnalyzer forClass(Class<?> ... classes) {
        return new DependencyAnalyzer(classes);
    }

    DependencyAnalyzer include(String prefix) {
        this.includes.add(prefix);
        return this;
    }

    DependencyAnalyzer exclude(String prefix) {
        this.excludes.add(prefix);
        return this;
    }

    synchronized Collection<Class<?>> getDependencies(Logger log) {
        if (this.dependencies != null) {
            return this.dependencies;
        }
        this.dependencies = new HashSet();
        for (Class<?> c : this.classes) {
            this.analyze(c, log);
        }
        for (String dep : this.dependencyNames) {
            this.dependencies.add(this.toClass(dep));
        }
        return this.dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(Class<?> c, Logger log) {
        if (this.alreadySeen.contains(c)) {
            return;
        }
        this.alreadySeen.add(c);
        HashSet deps = new HashSet();
        String path = "/" + c.getName().replace('.', '/') + ".class";
        InputStream input = this.getClass().getResourceAsStream(path);
        if (input == null) {
            throw new RuntimeException("Class resource not found: " + path);
        }
        log.trace("Analyzing dependencies of {}...", c);
        try {
            try {
                DependencyClassFileVisitor v = new DependencyClassFileVisitor();
                v.visitClass(c.getName(), input);
                deps.addAll(v.getDependencies());
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException while reading " + path);
        }
        for (String dep : deps) {
            if (dep.equals(c.getName()) || !this.accept(dep, log)) continue;
            this.dependencyNames.add(dep);
            this.analyze(this.toClass(dep), log);
        }
    }

    private boolean accept(String className, Logger log) {
        boolean result = false;
        for (String s : this.includes) {
            if (!className.startsWith(s)) continue;
            result = true;
            break;
        }
        if (result) {
            for (String s : this.excludes) {
                if (!className.startsWith(s)) continue;
                result = false;
                log.trace("Dependent class '{}' not included because package blacklisted via exclude '{}'.", (Object)className, (Object)s);
                break;
            }
        }
        if (result) {
            log.trace("Dependent class '{}' included because package not whitelisted via include.", (Object)className);
        } else {
            log.trace("Dependent class '{}' not included because package not whitelisted via include.", (Object)className);
        }
        return result;
    }

    private Class<?> toClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found :" + className, e);
        }
    }
}

