/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.osgi.bundleversion;

import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleVersionInfo<T>
implements Comparable<BundleVersionInfo<?>> {
    private static final int A_GREATER = 1;
    private static final int B_GREATER = -1;
    private static final int EQUAL = 0;
    public static final String SNAPSHOT_MARKER = "SNAPSHOT";
    public static final String BND_LAST_MODIFIED = "Bnd-LastModified";
    public static final long BND_LAST_MODIFIED_MISSING = -1L;

    public abstract T getSource();

    public abstract boolean isBundle();

    public abstract String getBundleSymbolicName();

    public abstract Version getVersion();

    public abstract boolean isSnapshot();

    public abstract long getBundleLastModified();

    @Override
    public int compareTo(BundleVersionInfo<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("b is null, cannot compare");
        }
        if (!this.isBundle()) {
            throw new IllegalArgumentException("Not a bundle, cannot compare: " + this);
        }
        if (!other.isBundle()) {
            throw new IllegalArgumentException("Not a bundle, cannot compare:" + other);
        }
        int result = this.getBundleSymbolicName().compareTo(other.getBundleSymbolicName());
        if (result == 0) {
            Version va = this.getVersion();
            Version vb = other.getVersion();
            if (va != null || vb != null) {
                result = vb == null ? 1 : (va == null ? -1 : va.compareTo((Object)vb));
            }
        }
        if (result == 0 && this.isSnapshot()) {
            long mb;
            long ma = this.getBundleLastModified();
            if (ma > (mb = other.getBundleLastModified())) {
                result = 1;
            } else if (mb > ma) {
                result = -1;
            }
        }
        return result;
    }
}

