/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepositoryInitializer.class})
public class SystemUsersInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String REPOINIT_FILE = "/repoinit.txt";
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        Session s = repo.loginAdministrative(null);
        InputStream is = this.getClass().getResourceAsStream(REPOINIT_FILE);
        try {
            List ops;
            if (is == null) {
                throw new IOException("Class Resource not found:/repoinit.txt");
            }
            try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                ops = this.parser.parse((Reader)r);
            }
            this.log.info("Executing {} repoinit Operations", (Object)ops.size());
            this.processor.apply(s, ops);
            s.save();
        }
        finally {
            s.logout();
            if (is != null) {
                is.close();
            }
        }
    }
}

