/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.internal.introspection.SandboxUberspect;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.ASTArrayAccess;
import org.apache.commons.jexl3.parser.ASTFunctionNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTMethodNode;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Engine
extends JexlEngine {
    protected final JexlUberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final Log logger;
    protected final Parser parser = new Parser(new StringReader(";"));
    protected final boolean strict;
    protected final boolean silent;
    protected final boolean debug;
    protected final Map<String, Object> functions;
    protected final SoftCache<String, ASTJexlScript> cache;
    protected final int cacheThreshold;
    protected final Charset charset;
    protected volatile TemplateEngine jxlt = null;
    private static final float LOAD_FACTOR = 0.75f;

    public Engine() {
        this(new JexlBuilder());
    }

    public Engine(JexlBuilder conf) {
        JexlSandbox sandbox = conf.sandbox();
        JexlUberspect uber = conf.uberspect() == null ? Engine.getUberspect(conf.logger(), conf.strategy()) : conf.uberspect();
        ClassLoader loader = conf.loader();
        if (loader != null) {
            uber.setClassLoader(loader);
        }
        this.uberspect = sandbox == null ? uber : new SandboxUberspect(uber, sandbox);
        this.logger = conf.logger() == null ? LogFactory.getLog(JexlEngine.class) : conf.logger();
        this.functions = conf.namespaces() == null ? Collections.emptyMap() : conf.namespaces();
        this.silent = conf.silent() == null ? false : conf.silent();
        this.debug = conf.debug() == null ? true : conf.debug();
        this.strict = conf.strict() == null ? true : conf.strict();
        this.arithmetic = conf.arithmetic() == null ? new JexlArithmetic(this.strict) : conf.arithmetic();
        this.cache = conf.cache() <= 0 ? null : new SoftCache(conf.cache());
        this.cacheThreshold = conf.cacheThreshold();
        this.charset = conf.charset();
        if (this.uberspect == null) {
            throw new IllegalArgumentException("uberspect can not be null");
        }
    }

    public static Uberspect getUberspect(Log logger, JexlUberspect.ResolverStrategy strategy) {
        if (!(logger != null && !logger.equals(LogFactory.getLog(JexlEngine.class)) || strategy != null && strategy != JexlUberspect.JEXL_STRATEGY)) {
            return UberspectHolder.UBERSPECT;
        }
        return new Uberspect(logger, strategy);
    }

    @Override
    public JexlUberspect getUberspect() {
        return this.uberspect;
    }

    @Override
    public JexlArithmetic getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public TemplateEngine createJxltEngine(boolean noScript, int cacheSize, char immediate, char deferred) {
        return new TemplateEngine(this, noScript, cacheSize, immediate, deferred);
    }

    protected JexlContext.ThreadLocal putThreadLocal(JexlContext.ThreadLocal tls) {
        JexlContext.ThreadLocal local = (JexlContext.ThreadLocal)CONTEXT.get();
        CONTEXT.set(tls);
        return local;
    }

    protected <K, V> Map<K, V> createCache(final int cacheSize) {
        return new LinkedHashMap<K, V>(cacheSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Parser parser = this.parser;
        synchronized (parser) {
            if (this.cache != null) {
                this.cache.clear();
            }
        }
    }

    protected Interpreter createInterpreter(JexlContext context, Scope.Frame frame) {
        return new Interpreter(this, context, frame);
    }

    @Override
    public Script createScript(JexlInfo info, String scriptText, String[] names) {
        if (scriptText == null) {
            throw new NullPointerException("source is null");
        }
        if (info == null && this.debug) {
            info = this.createInfo();
        }
        String source = this.trimSource(scriptText);
        Scope scope = names == null ? null : new Scope(null, names);
        ASTJexlScript tree = this.parse(info, source, scope, false, false);
        return new Script(this, source, tree);
    }

    @Override
    public Script createExpression(JexlInfo info, String expression) {
        if (expression == null) {
            throw new NullPointerException("source is null");
        }
        if (info == null && this.debug) {
            info = this.createInfo();
        }
        String source = this.trimSource(expression);
        ASTJexlScript tree = this.parse(info, source, null, false, true);
        return new Script(this, source, tree);
    }

    @Override
    public Object getProperty(Object bean, String expr) {
        return this.getProperty(null, bean, expr);
    }

    @Override
    public Object getProperty(JexlContext context, Object bean, String expr) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        String src = this.trimSource(expr);
        src = "#0" + (src.charAt(0) == '[' ? "" : ".") + src;
        try {
            JexlInfo info = this.debug ? this.createInfo() : null;
            Scope scope = new Scope(null, "#0");
            ASTJexlScript script = this.parse(info, src, scope, true, true);
            JexlNode node = script.jjtGetChild(0);
            Scope.Frame frame = script.createFrame(bean);
            Interpreter interpreter = this.createInterpreter(context, frame);
            return node.jjtAccept(interpreter, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                return null;
            }
            throw xjexl.clean();
        }
    }

    @Override
    public void setProperty(Object bean, String expr, Object value) {
        this.setProperty(null, bean, expr, value);
    }

    @Override
    public void setProperty(JexlContext context, Object bean, String expr, Object value) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        String src = this.trimSource(expr);
        src = "#0" + (src.charAt(0) == '[' ? "" : ".") + src + "=" + "#1";
        try {
            JexlInfo info = this.debug ? this.createInfo() : null;
            Scope scope = new Scope(null, "#0", "#1");
            ASTJexlScript script = this.parse(info, src, scope, true, true);
            JexlNode node = script.jjtGetChild(0);
            Scope.Frame frame = script.createFrame(bean, value);
            Interpreter interpreter = this.createInterpreter(context, frame);
            node.jjtAccept(interpreter, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                return;
            }
            throw xjexl.clean();
        }
    }

    @Override
    public Object invokeMethod(Object obj, String meth, Object ... args) {
        JexlException xjexl = null;
        Object result = null;
        JexlInfo info = this.debug ? this.createInfo() : null;
        try {
            JexlMethod method = this.uberspect.getMethod(obj, meth, args);
            if (method == null && this.arithmetic.narrowArguments(args)) {
                method = this.uberspect.getMethod(obj, meth, args);
            }
            if (method != null) {
                result = method.invoke(obj, args);
            } else {
                xjexl = new JexlException.Method(info, meth, null);
            }
        }
        catch (JexlException xany) {
            xjexl = xany;
        }
        catch (Exception xany) {
            xjexl = new JexlException.Method(info, meth, (Throwable)xany);
        }
        if (xjexl != null) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                result = null;
            } else {
                throw xjexl.clean();
            }
        }
        return result;
    }

    @Override
    public <T> T newInstance(Class<? extends T> clazz, Object ... args) {
        return clazz.cast(this.doCreateInstance(clazz, args));
    }

    @Override
    public Object newInstance(String clazz, Object ... args) {
        return this.doCreateInstance(clazz, args);
    }

    protected Object doCreateInstance(Object clazz, Object ... args) {
        JexlException xjexl = null;
        Object result = null;
        JexlInfo info = this.debug ? this.createInfo() : null;
        try {
            JexlMethod ctor = this.uberspect.getConstructor(clazz, args);
            if (ctor == null && this.arithmetic.narrowArguments(args)) {
                ctor = this.uberspect.getConstructor(clazz, args);
            }
            if (ctor != null) {
                result = ctor.invoke(clazz, args);
            } else {
                xjexl = new JexlException.Method(info, clazz.toString(), null);
            }
        }
        catch (JexlException xany) {
            xjexl = xany;
        }
        catch (Exception xany) {
            xjexl = new JexlException.Method(info, clazz.toString(), (Throwable)xany);
        }
        if (xjexl != null) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                return null;
            }
            throw xjexl.clean();
        }
        return result;
    }

    protected Set<List<String>> getVariables(ASTJexlScript script) {
        VarCollector collector = new VarCollector();
        this.getVariables(script, script, collector);
        return collector.collected();
    }

    protected void getVariables(ASTJexlScript script, JexlNode node, VarCollector collector) {
        if (node instanceof ASTIdentifier) {
            JexlNode parent = node.jjtGetParent();
            if (parent instanceof ASTMethodNode || parent instanceof ASTFunctionNode) {
                collector.collect(null);
                return;
            }
            ASTIdentifier identifier = (ASTIdentifier)node;
            int symbol = identifier.getSymbol();
            if (symbol >= 0 && script != null && !script.isHoistedSymbol(symbol)) {
                collector.collect(null);
            } else {
                collector.collect(identifier);
                collector.add(identifier.getName());
            }
        } else if (node instanceof ASTIdentifierAccess) {
            JexlNode parent = node.jjtGetParent();
            if (parent instanceof ASTMethodNode || parent instanceof ASTFunctionNode) {
                collector.collect(null);
                return;
            }
            if (collector.isCollecting()) {
                collector.add(((ASTIdentifierAccess)node).getName());
            }
        } else if (node instanceof ASTArrayAccess) {
            int num = node.jjtGetNumChildren();
            boolean collecting = collector.isCollecting();
            for (int i = 0; i < num; ++i) {
                JexlNode child = node.jjtGetChild(i);
                if (collecting && child.isConstant()) {
                    String image = child.toString();
                    if (image == null) {
                        image = new Debugger().data(child);
                    }
                    collector.add(image);
                    continue;
                }
                collecting = false;
                collector.collect(null);
                this.getVariables(script, child, collector);
            }
        } else {
            int num = node.jjtGetNumChildren();
            for (int i = 0; i < num; ++i) {
                this.getVariables(script, node.jjtGetChild(i), collector);
            }
            collector.collect(null);
        }
    }

    protected String[] getParameters(JexlScript script) {
        return script.getParameters();
    }

    protected String[] getLocalVariables(JexlScript script) {
        return script.getLocalVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ASTJexlScript parse(JexlInfo info, String src, Scope scope, boolean registers, boolean expression) {
        ASTJexlScript script;
        boolean cached = src.length() < this.cacheThreshold && this.cache != null;
        Parser parser = this.parser;
        synchronized (parser) {
            Scope f;
            if (cached && (script = this.cache.get(src)) != null && ((f = script.getScope()) == null && scope == null || f != null && f.equals(scope))) {
                return script;
            }
            script = this.parser.parse(info, src, scope, registers, expression);
            if (cached) {
                this.cache.put(src, script);
            }
        }
        return script;
    }

    protected String trimSource(CharSequence str) {
        if (str != null) {
            int end = str.length();
            if (end > 0) {
                int start;
                for (start = 0; start < end && Character.isSpaceChar(str.charAt(start)); ++start) {
                }
                while (end > 0 && Character.isSpaceChar(str.charAt(end - 1))) {
                    --end;
                }
                return str.subSequence(start, end).toString();
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateEngine jxlt() {
        TemplateEngine e = this.jxlt;
        if (e == null) {
            Engine engine = this;
            synchronized (engine) {
                if (this.jxlt == null) {
                    this.jxlt = e = new TemplateEngine(this, true, 0, '$', '#');
                }
            }
        }
        return e;
    }

    protected static class VarCollector {
        private final Set<List<String>> refs = new LinkedHashSet<List<String>>();
        private List<String> ref = new ArrayList<String>();
        private JexlNode root = null;

        protected VarCollector() {
        }

        public void collect(JexlNode node) {
            if (!this.ref.isEmpty()) {
                this.refs.add(this.ref);
                this.ref = new ArrayList<String>();
            }
            this.root = node;
        }

        public boolean isCollecting() {
            return this.root instanceof ASTIdentifier;
        }

        public void add(String name) {
            this.ref.add(name);
        }

        public Set<List<String>> collected() {
            return this.refs;
        }
    }

    protected class SoftCache<K, V> {
        private final int size;
        private SoftReference<Map<K, V>> ref = null;

        SoftCache(int theSize) {
            this.size = theSize;
        }

        int size() {
            return this.size;
        }

        void clear() {
            this.ref = null;
        }

        Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? map.entrySet() : Collections.emptySet();
        }

        V get(K key) {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? (V)map.get(key) : null;
        }

        void put(K key, V script) {
            Map<K, V> map;
            Map<K, V> map2 = map = this.ref != null ? this.ref.get() : null;
            if (map == null) {
                map = Engine.this.createCache(this.size);
                this.ref = new SoftReference<Map<K, V>>(map);
            }
            map.put(key, script);
        }
    }

    private static final class UberspectHolder {
        private static final Uberspect UBERSPECT = new Uberspect(LogFactory.getLog(JexlEngine.class), JexlUberspect.JEXL_STRATEGY);

        private UberspectHolder() {
        }
    }
}

