/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.AbstractPlumberServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.extensions=json", "sling.servlet.extensions=csv"})
@Designate(ocd=Configuration.class)
public class PlumberServlet
extends AbstractPlumberServlet {
    public static final String RESOURCE_TYPE = "slingPipes/plumber";
    static final String PARAM_PATH = "path";
    static final String PARAM_BINDINGS = "bindings";
    static final String PARAM_ASYNC = "async";
    @Reference
    Plumber plumber;
    boolean enabled = false;

    @Activate
    @Modified
    public void activate(Configuration configuration) {
        this.enabled = configuration.enabled();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.enabled) {
            if (Arrays.asList(request.getRequestPathInfo().getSelectors()).contains("status")) {
                response.getWriter().append(this.plumber.getStatus(request.getResource()));
            } else {
                this.execute(request, response, false);
            }
        } else {
            response.setStatus(503);
            response.sendError(503, "http service has been disabled");
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.enabled) {
            this.execute(request, response, true);
        } else {
            response.setStatus(503);
            response.sendError(503, "http service has been disabled");
        }
    }

    void execute(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean writeAllowed) throws ServletException {
        String path = request.getResource().getResourceType().equals(RESOURCE_TYPE) ? request.getParameter(PARAM_PATH) : request.getResource().getPath();
        try {
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new IllegalArgumentException("path should be provided");
            }
            Map<String, Object> bindings = this.plumber.getBindingsFromRequest(request, writeAllowed);
            String asyncParam = request.getParameter(PARAM_ASYNC);
            if (StringUtils.isNotBlank((CharSequence)asyncParam) && asyncParam.equals(Boolean.TRUE.toString())) {
                Job job = this.plumber.executeAsync(request.getResourceResolver(), path, bindings);
                if (job != null) {
                    response.getWriter().append("pipe execution registered as " + job.getId());
                    response.setStatus(201);
                } else {
                    response.sendError(500, "Some issue with your request, or server not being ready for async execution");
                }
            } else {
                OutputWriter writer = this.getWriter(request, response);
                this.plumber.execute(request.getResourceResolver(), path, bindings, writer, true);
            }
        }
        catch (AccessControlException e) {
            response.setStatus(403);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Pipes : Plumber Servlet Configuration")
    public static @interface Configuration {
        @AttributeDefinition(description="Enable servlet to execute pipe, if disabled will return 503")
        public boolean enabled() default true;

        @AttributeDefinition(description="Resource types with which that servlet can be called")
        public String[] sling_servlet_resourceTypes() default {"slingPipes/plumber", "slingPipes/container", "slingPipes/manifold", "slingPipes/authorizable", "slingPipes/write", "slingPipes/children"};
    }
}

