/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;

public final class EvalResult {
    private final ExpressionNode node;
    private final Object value;

    public static EvalResult constant(Object obj) {
        return new EvalResult(null, obj);
    }

    public static EvalResult nonConstant(ExpressionNode node) {
        return new EvalResult(node, null);
    }

    private EvalResult(ExpressionNode node, Object value) {
        this.node = node;
        this.value = value;
    }

    public boolean isConstant() {
        return this.node == null;
    }

    public Object getValue() {
        if (!this.isConstant()) {
            throw new SightlyCompilerException("Cannot get constant value from non-constant result.");
        }
        return this.value;
    }

    public ExpressionNode getNode() {
        return this.isConstant() ? EvalResult.asLiteral(this.getValue()) : this.node;
    }

    private static ExpressionNode asLiteral(Object value) {
        if (value instanceof Boolean) {
            return new BooleanConstant((Boolean)value);
        }
        if (value instanceof String) {
            return new StringConstant((String)value);
        }
        if (value instanceof Number) {
            return new NumericConstant((Number)value);
        }
        if (value instanceof Map) {
            return EvalResult.asMapLiteral((Map)value);
        }
        if (value instanceof List) {
            return EvalResult.asArrayLiteral((List)value);
        }
        if (value == null) {
            return NullLiteral.INSTANCE;
        }
        throw new SightlyCompilerException("Cannot transform to literal: " + value);
    }

    private static MapLiteral asMapLiteral(Map<String, Object> map) {
        HashMap<String, ExpressionNode> literal = new HashMap<String, ExpressionNode>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            literal.put(entry.getKey(), EvalResult.asLiteral(entry.getValue()));
        }
        return new MapLiteral(literal);
    }

    private static ArrayLiteral asArrayLiteral(List<Object> list) {
        ArrayList<ExpressionNode> literal = new ArrayList<ExpressionNode>();
        for (Object obj : list) {
            literal.add(EvalResult.asLiteral(obj));
        }
        return new ArrayLiteral(literal);
    }
}

