/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.apache.sling.serviceusermapping.impl.felix.utils.json.JSONWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.format=JSON", "felix.inventory.printer.format=TEXT", "felix.inventory.printer.title=Sling Service User Mappings", "felix.inventory.printer.name=sling-serviceusermappings", "felix.inventory.printer.webconsole:Boolean=true"})
public class MappingInventoryPrinter
implements InventoryPrinter {
    @Reference
    private ServiceUserMapperImpl mapper;

    public void print(PrintWriter out, Format format, boolean isZip) {
        try {
            if (format.equals(Format.JSON)) {
                this.renderJson(out);
            } else if (format.equals(Format.TEXT)) {
                this.renderText(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    private String getMappedUser(Mapping m) {
        return m.map(m.getServiceName(), m.getSubServiceName());
    }

    private String[] getMappedPrincipalNames(Mapping m) {
        Iterable<String> principalNames = m.mapPrincipals(m.getServiceName(), m.getSubServiceName());
        if (principalNames == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String pName : principalNames) {
            l.add(pName);
        }
        return l.toArray(new String[l.size()]);
    }

    private SortedMap<String, List<Mapping>> getMappingsByUser(List<Mapping> mappings) {
        TreeMap<String, List<Mapping>> result = new TreeMap<String, List<Mapping>>();
        for (Mapping m : mappings) {
            String user = this.getMappedUser(m);
            if (user == null) continue;
            ArrayList<Mapping> list = (ArrayList<Mapping>)result.get(user);
            if (list == null) {
                list = new ArrayList<Mapping>();
                result.put(user, list);
            }
            list.add(m);
        }
        return result;
    }

    private SortedMap<String, List<Mapping>> getMappingsByPrincipalName(List<Mapping> mappings) {
        TreeMap<String, List<Mapping>> result = new TreeMap<String, List<Mapping>>();
        for (Mapping m : mappings) {
            String[] principalNames = this.getMappedPrincipalNames(m);
            if (principalNames == null) continue;
            for (String pName : principalNames) {
                ArrayList<Mapping> list = (ArrayList<Mapping>)result.get(pName);
                if (list == null) {
                    list = new ArrayList<Mapping>();
                    result.put(pName, list);
                }
                list.add(m);
            }
        }
        return result;
    }

    private void asJSON(JSONWriter w, Mapping m) throws IOException {
        w.object();
        w.key("serviceName").value(m.getServiceName());
        w.key("subServiceName").value(m.getSubServiceName());
        String[] pNames = this.getMappedPrincipalNames(m);
        if (pNames != null) {
            w.key("principals").value(pNames);
        } else {
            w.key("user").value(this.getMappedUser(m));
        }
        w.endObject();
    }

    private void renderJson(PrintWriter out) throws IOException {
        List<Mapping> data = this.mapper.getActiveMappings();
        SortedMap<String, List<Mapping>> byUser = this.getMappingsByUser(data);
        SortedMap<String, List<Mapping>> byPrincipalName = this.getMappingsByPrincipalName(data);
        JSONWriter w = new JSONWriter(out);
        w.object();
        w.key("title").value("Service User Mappings");
        w.key("mappingsCount").value(data.size());
        w.key("uniquePrincipalsCount").value(byPrincipalName.keySet().size());
        w.key("uniqueUsersCount").value(byUser.keySet().size());
        w.key("mappingsByPrincipal");
        w.object();
        for (Map.Entry e : byPrincipalName.entrySet()) {
            w.key((String)e.getKey());
            w.array();
            for (Mapping m : (List)e.getValue()) {
                this.asJSON(w, m);
            }
            w.endArray();
        }
        w.endObject();
        w.key("mappingsByUser (deprecated)");
        w.object();
        for (Map.Entry e : byUser.entrySet()) {
            w.key((String)e.getKey());
            w.array();
            for (Mapping m : (List)e.getValue()) {
                this.asJSON(w, m);
            }
            w.endArray();
        }
        w.endObject();
        w.endObject();
    }

    private void asText(PrintWriter w, Mapping m, String indent) {
        String SEP = " / ";
        w.print(indent);
        w.print(m.getServiceName());
        w.print(" / ");
        String sub = m.getSubServiceName();
        w.print(sub == null ? "" : sub);
        w.print(" / ");
        Object[] principalNames = this.getMappedPrincipalNames(m);
        if (principalNames != null) {
            w.println(Arrays.toString(principalNames));
        } else {
            w.println(this.getMappedUser(m));
        }
    }

    private void renderText(PrintWriter out) {
        List<Mapping> data = this.mapper.getActiveMappings();
        SortedMap<String, List<Mapping>> byPrincipalName = this.getMappingsByPrincipalName(data);
        out.print("*** Mappings by principals (");
        out.print(byPrincipalName.keySet().size());
        out.print(" principals):");
        out.println(" (format: service name / sub service name / principal names)");
        for (Map.Entry e : byPrincipalName.entrySet()) {
            out.print("  ");
            out.println((String)e.getKey());
            for (Mapping m : (List)e.getValue()) {
                this.asText(out, m, "    ");
            }
        }
        SortedMap<String, List<Mapping>> byUser = this.getMappingsByUser(data);
        out.println();
        out.print("*** Deprecated mappings by user (");
        out.print(byUser.keySet().size());
        out.print(" users):");
        out.println(" (format: service name / sub service name / user)");
        for (Map.Entry e : byUser.entrySet()) {
            out.print("  ");
            out.println((String)e.getKey());
            for (Mapping m : (List)e.getValue()) {
                this.asText(out, m, "    ");
            }
        }
    }
}

