/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.apache.sling.testing.clients.interceptors.UserAgentHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentInterceptor
implements HttpRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String USER_AGENT_HEADER = "User-Agent";

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (UserAgentHolder.get() == null) {
            return;
        }
        if (httpRequest.containsHeader(USER_AGENT_HEADER)) {
            if (!httpRequest.getFirstHeader(USER_AGENT_HEADER).getValue().equals(SystemPropertiesConfig.getDefaultUserAgent())) {
                this.log.warn("User-agent of client-request changed manually; use CustomUserAgentRule instead!");
                return;
            }
            httpRequest.removeHeaders(USER_AGENT_HEADER);
        }
        httpRequest.addHeader(USER_AGENT_HEADER, UserAgentHolder.get());
    }
}

