/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.mem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.mem.MemoryFile;
import org.apache.jackrabbit.core.fs.mem.MemoryFileSystemEntry;
import org.apache.jackrabbit.core.fs.mem.MemoryFolder;

public class MemoryFileSystem
implements FileSystem {
    private Map<String, MemoryFileSystemEntry> entries = new HashMap<String, MemoryFileSystemEntry>();

    public void close() {
    }

    private MemoryFile getFile(String filePath) throws FileSystemException {
        MemoryFileSystemEntry entry = this.getEntry(filePath);
        this.assertIsFile(filePath);
        return (MemoryFile)entry;
    }

    public void createFolder(String folderPath) throws FileSystemException {
        if (this.exists(folderPath)) {
            throw new FileSystemException("Folder or file " + folderPath + " already exists");
        }
        if (!this.exists("/")) {
            this.createFolderInternal("/");
        }
        String relativePath = folderPath.substring(1);
        String[] pathElements = relativePath.split("/");
        String currentFolderPath = "";
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            currentFolderPath = currentFolderPath + "/" + pathElement;
            this.createFolderInternal(currentFolderPath);
        }
    }

    private void createFolderInternal(String folderPath) {
        MemoryFolder folder = new MemoryFolder();
        this.entries.put(folderPath, folder);
    }

    public void deleteFile(String filePath) throws FileSystemException {
        this.assertExistence(filePath);
        this.entries.remove(filePath);
    }

    public void deleteFolder(String folderPath) throws FileSystemException {
        this.assertIsFolder(folderPath);
        HashSet<String> selectedNames = new HashSet<String>();
        for (String name : this.entries.keySet()) {
            if (!name.equals(folderPath) && !name.startsWith(folderPath + "/")) continue;
            selectedNames.add(name);
        }
        for (String name : selectedNames) {
            this.entries.remove(name);
        }
    }

    public boolean exists(String path) throws FileSystemException {
        return this.entries.containsKey(path);
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        this.assertExistence(filePath);
        this.assertIsFile(filePath);
        MemoryFile file = this.getFile(filePath);
        return new ByteArrayInputStream(file.getData());
    }

    private void assertIsFolder(String folderPath) throws FileSystemException {
        this.assertExistence(folderPath);
        if (!this.getEntry(folderPath).isFolder()) {
            throw new FileSystemException("Folder " + folderPath + " does not exist");
        }
    }

    private void assertIsFile(String filePath) throws FileSystemException {
        if (!this.isFile(filePath)) {
            throw new FileSystemException(filePath + " is a folder");
        }
    }

    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        String folderPath = filePath;
        folderPath = filePath.lastIndexOf("/") > 0 ? filePath.substring(0, filePath.lastIndexOf("/")) : "/";
        this.assertIsFolder(folderPath);
        final MemoryFile file = new MemoryFile();
        this.entries.put(filePath, file);
        return new FilterOutputStream(new ByteArrayOutputStream()){

            public void write(byte[] bytes, int off, int len) throws IOException {
                this.out.write(bytes, off, len);
            }

            public void close() throws IOException {
                this.out.close();
                file.setData(((ByteArrayOutputStream)this.out).toByteArray());
            }
        };
    }

    public boolean hasChildren(String path) throws FileSystemException {
        this.assertIsFolder(path);
        return this.list(path).length > 0;
    }

    public void init() {
        this.createFolderInternal("/");
    }

    public boolean isFile(String path) throws FileSystemException {
        return this.exists(path) && !this.getEntry(path).isFolder();
    }

    private MemoryFileSystemEntry getEntry(String path) {
        return this.entries.get(path);
    }

    private void assertExistence(String path) throws FileSystemException {
        if (!this.exists(path)) {
            throw new FileSystemException("no such file " + path);
        }
    }

    public boolean isFolder(String path) throws FileSystemException {
        if (path.equals("/")) {
            return true;
        }
        return this.exists(path) && this.getEntry(path).isFolder();
    }

    public long lastModified(String path) throws FileSystemException {
        this.assertExistence(path);
        return this.getEntry(path).getLastModified();
    }

    public long length(String filePath) throws FileSystemException {
        this.assertIsFile(filePath);
        return this.getFile(filePath).getData().length;
    }

    public String[] list(String folderPath) {
        if (folderPath.equals("/")) {
            folderPath = "";
        }
        HashSet<String> selectedNames = new HashSet<String>();
        for (String name : this.entries.keySet()) {
            if (!name.matches(folderPath + "/[^/]*") || name.equals("/")) continue;
            selectedNames.add(name.substring(folderPath.length() + 1));
        }
        return selectedNames.toArray(new String[selectedNames.size()]);
    }

    public String[] listFiles(String folderPath) {
        return this.listInternal(folderPath, false);
    }

    public String[] listFolders(String folderPath) {
        return this.listInternal(folderPath, true);
    }

    private String[] listInternal(String folderPath, boolean isFolder) {
        String[] names = this.list(folderPath);
        if (folderPath.equals("/")) {
            folderPath = "";
        }
        HashSet<String> result = new HashSet<String>();
        for (String n : names) {
            if (this.getEntry(folderPath + "/" + n).isFolder() != isFolder) continue;
            result.add(n);
        }
        return result.toArray(new String[result.size()]);
    }
}

