/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.id;

import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class PropertyId
implements ItemId {
    static final long serialVersionUID = 1118783735407446009L;
    private final NodeId parentId;
    private final Name propName;
    private final int hashCode;

    public PropertyId(NodeId parentId, Name propName) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId can not be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("propName can not be null");
        }
        this.parentId = parentId;
        this.propName = propName;
        int h = 17;
        h = 37 * h + parentId.hashCode();
        this.hashCode = h = 37 * h + propName.hashCode();
    }

    public boolean denotesNode() {
        return false;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public Name getName() {
        return this.propName;
    }

    public static PropertyId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid PropertyId literal");
        }
        int i = s.indexOf(47);
        if (i == -1) {
            throw new IllegalArgumentException("invalid PropertyId literal");
        }
        String uuid = s.substring(0, i);
        Name name = NameFactoryImpl.getInstance().create(s.substring(i + 1));
        return new PropertyId(NodeId.valueOf(uuid), name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyId) {
            PropertyId other = (PropertyId)obj;
            return this.parentId.equals(other.parentId) && this.propName.equals(other.propName);
        }
        return false;
    }

    public String toString() {
        return this.parentId + "/" + this.propName;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

