/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLockManager
implements javax.jcr.lock.LockManager {
    private static Logger log = LoggerFactory.getLogger(SessionLockManager.class);
    private final SessionContext context;
    private final SessionImpl session;
    private final LockManager systemLockMgr;
    private final Set<String> lockTokens = new HashSet<String>();

    public SessionLockManager(SessionContext context, LockManager systemLockMgr) {
        this.context = context;
        this.session = context.getSessionImpl();
        this.systemLockMgr = systemLockMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockTokens() throws RepositoryException {
        Set<String> set = this.lockTokens;
        synchronized (set) {
            String[] result = new String[this.lockTokens.size()];
            this.lockTokens.toArray(result);
            return result;
        }
    }

    public void addLockToken(String lockToken) throws LockException, RepositoryException {
        if (!this.lockTokens.contains(lockToken)) {
            this.systemLockMgr.addLockToken(this.session, lockToken);
        } else {
            log.debug("Lock token already present with session -> no effect.");
        }
    }

    public void removeLockToken(String lockToken) throws LockException, RepositoryException {
        if (!this.lockTokens.contains(lockToken)) {
            throw new LockException("Lock token " + lockToken + " not present with session.");
        }
        this.systemLockMgr.removeLockToken(this.session, lockToken);
    }

    public boolean isLocked(String absPath) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew()) {
            while (node.isNew()) {
                node = (NodeImpl)node.getParent();
            }
            return this.systemLockMgr.isLocked(node) && this.systemLockMgr.getLock(node).isDeep();
        }
        return this.systemLockMgr.isLocked(node);
    }

    public Lock getLock(String absPath) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew()) {
            while (node.isNew()) {
                node = (NodeImpl)node.getParent();
            }
            Lock l = this.systemLockMgr.getLock(node);
            if (l.isDeep()) {
                return l;
            }
            throw new LockException("Node not locked: " + node);
        }
        return this.systemLockMgr.getLock(node);
    }

    public boolean holdsLock(String absPath) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew() || !node.isNodeType(NameConstants.MIX_LOCKABLE)) {
            return false;
        }
        return this.systemLockMgr.holdsLock(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        int options = 192;
        this.context.getItemValidator().checkModify(node, options, 512);
        SessionLockManager.checkLockable(node);
        LockManager lockManager = this.systemLockMgr;
        synchronized (lockManager) {
            return this.systemLockMgr.lock(node, isDeep, isSessionScoped, timeoutHint, ownerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String absPath) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        int options = 192;
        this.context.getItemValidator().checkModify(node, options, 512);
        SessionLockManager.checkLockable(node);
        LockManager lockManager = this.systemLockMgr;
        synchronized (lockManager) {
            if (!this.systemLockMgr.holdsLock(node)) {
                throw new LockException("Node not locked: " + node);
            }
            this.systemLockMgr.checkUnlock(this.session, node);
            this.systemLockMgr.unlock(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lockTokenAdded(String lockToken) {
        Set<String> set = this.lockTokens;
        synchronized (set) {
            return this.lockTokens.add(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lockTokenRemoved(String lockToken) {
        Set<String> set = this.lockTokens;
        synchronized (set) {
            return this.lockTokens.remove(lockToken);
        }
    }

    private static void checkLockable(NodeImpl node) throws LockException, RepositoryException {
        if (!node.isNodeType(NameConstants.MIX_LOCKABLE)) {
            String msg = "Unable to perform a locking operation on a non-lockable node: " + node.safeGetJCRPath();
            log.debug(msg);
            throw new LockException(msg);
        }
    }
}

