/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.retention;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.retention.Hold;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

class HoldImpl
implements Hold {
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final String DEEP = "D_";
    private static final String SHALLOW = "S_";
    private final Name name;
    private final boolean isDeep;
    private final NodeId nodeId;
    private final NameResolver resolver;
    private int hashCode = 0;

    HoldImpl(Name name, boolean isDeep, NodeId nodeId, NameResolver resolver) {
        this.name = name;
        this.isDeep = isDeep;
        this.nodeId = nodeId;
        this.resolver = resolver;
    }

    NodeId getNodeId() {
        return this.nodeId;
    }

    Value toValue(ValueFactory valueFactory) throws RepositoryException {
        String str = (this.isDeep ? DEEP : SHALLOW) + this.name.toString();
        return valueFactory.createValue(str);
    }

    static HoldImpl createFromValue(Value val, NodeId nodeId, NameResolver resolver) throws RepositoryException {
        String str = val.getString();
        Name name = NAME_FACTORY.create(str.substring(2));
        boolean isDeep = str.startsWith(DEEP);
        return new HoldImpl(name, isDeep, nodeId, resolver);
    }

    static HoldImpl[] createFromProperty(PropertyImpl property, NodeId nodeId) throws RepositoryException {
        Value[] vs = property.getValues();
        HoldImpl[] holds = new HoldImpl[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            holds[i] = HoldImpl.createFromValue(vs[i], nodeId, (SessionImpl)property.getSession());
        }
        return holds;
    }

    public boolean isDeep() throws RepositoryException {
        return this.isDeep;
    }

    public String getName() throws RepositoryException {
        return this.resolver.getJCRName(this.name);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int h = 17;
            h = 37 * h + this.name.hashCode();
            h = 37 * h + this.nodeId.hashCode();
            this.hashCode = h = 37 * h + Boolean.valueOf(this.isDeep).hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HoldImpl) {
            HoldImpl other = (HoldImpl)obj;
            return this.isDeep == other.isDeep && this.name.equals(other.name) && this.nodeId.equals(other.nodeId);
        }
        return false;
    }
}

