/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.spi.Path;

public abstract class AbstractCompiledPermissions
implements CompiledPermissions {
    private final Map<Path, Result> cache;
    private final Object monitor = new Object();

    protected AbstractCompiledPermissions() {
        this.cache = new LRUMap(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getResult(Path absPath) throws RepositoryException {
        Result result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.cache.get(absPath);
            if (result == null) {
                result = this.buildResult(absPath);
                this.cache.put(absPath, result);
            }
        }
        return result;
    }

    protected abstract Result buildResult(Path var1) throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.monitor;
        synchronized (object) {
            this.cache.clear();
        }
    }

    public void close() {
        this.clearCache();
    }

    public boolean grants(Path absPath, int permissions) throws RepositoryException {
        return this.getResult(absPath).grants(permissions);
    }

    public int getPrivileges(Path absPath) throws RepositoryException {
        return this.getResult(absPath).getPrivileges();
    }

    public boolean canReadAll() throws RepositoryException {
        return false;
    }

    public static class Result {
        public static final Result EMPTY = new Result(0, 0, 0, 0);
        private final int allows;
        private final int denies;
        private final int allowPrivileges;
        private final int denyPrivileges;
        private int hashCode = -1;

        public Result(int allows, int denies, int allowPrivileges, int denyPrivileges) {
            this.allows = allows;
            this.denies = denies;
            this.allowPrivileges = allowPrivileges;
            this.denyPrivileges = denyPrivileges;
        }

        public boolean grants(int permissions) {
            return (this.allows | ~permissions) == -1;
        }

        public int getPrivileges() {
            return this.allowPrivileges;
        }

        public Result combine(Result other) {
            int cAllows = this.allows | Permission.diff(other.allows, this.denies);
            int cDenies = this.denies | Permission.diff(other.denies, this.allows);
            int cAPrivs = this.allowPrivileges | Permission.diff(other.allowPrivileges, this.denyPrivileges);
            int cDPrivs = this.denyPrivileges | Permission.diff(other.denyPrivileges, this.allowPrivileges);
            return new Result(cAllows, cDenies, cAPrivs, cDPrivs);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int h = 17;
                h = 37 * h + this.allows;
                h = 37 * h + this.denies;
                h = 37 * h + this.allowPrivileges;
                this.hashCode = h = 37 * h + this.denyPrivileges;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Result) {
                Result other = (Result)object;
                return this.allows == other.allows && this.denies == other.denies && this.allowPrivileges == other.allowPrivileges && this.denyPrivileges == other.denyPrivileges;
            }
            return false;
        }
    }
}

