/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Splitter;
import sling-mock-oak.com.google.common.collect.ImmutableSet;

public class NotFullTextSearchImpl
extends FullTextSearchImpl {
    private static final Set<String> KEYWORDS = ImmutableSet.of("or");
    private static final Splitter SPACE_SPLITTER = Splitter.on(' ').omitEmptyStrings().trimResults();

    public NotFullTextSearchImpl(String selectorName, String propertyName, StaticOperandImpl fullTextSearchExpression) {
        super(selectorName, propertyName, fullTextSearchExpression);
    }

    public NotFullTextSearchImpl(FullTextSearchImpl ft) {
        this(ft.selectorName, ft.propertyName, ft.fullTextSearchExpression);
    }

    @Override
    ConstraintImpl not() {
        return new FullTextSearchImpl(this.selectorName, this.propertyName, this.fullTextSearchExpression);
    }

    @Override
    String getRawText(PropertyValue v) {
        Iterable<String> terms = SPACE_SPLITTER.split(super.getRawText(v));
        StringBuffer raw = new StringBuffer();
        for (String term : terms) {
            if (NotFullTextSearchImpl.isKeyword(term)) {
                raw.append(String.format("%s ", term));
                continue;
            }
            raw.append(String.format("-%s ", term));
        }
        return raw.toString().trim();
    }

    private static boolean isKeyword(@NotNull String term) {
        return KEYWORDS.contains(Preconditions.checkNotNull(term).toLowerCase());
    }

    @Override
    void restrictPropertyOnFilter(String propertyName, FilterImpl f) {
    }

    @Override
    public String toString() {
        return "not " + super.toString();
    }

    @Override
    boolean enforcePropertyExistence(String propertyName, SelectorImpl selector) {
        return true;
    }

    @Override
    public boolean requiresFullTextIndex() {
        return true;
    }
}

