/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class SameNodeJoinConditionImpl
extends JoinConditionImpl {
    private final String selector1Name;
    private final String selector2Name;
    private final String selector2Path;
    private SelectorImpl selector1;
    private SelectorImpl selector2;

    public SameNodeJoinConditionImpl(String selector1Name, String selector2Name, String selector2Path) {
        this.selector1Name = selector1Name;
        this.selector2Name = selector2Name;
        this.selector2Path = selector2Path;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("issamenode(");
        builder.append(this.quote(this.selector1Name));
        builder.append(", ");
        builder.append(this.quote(this.selector2Name));
        if (this.selector2Path != null) {
            builder.append(", ");
            builder.append(this.quote(this.selector2Path));
        }
        builder.append(')');
        return builder.toString();
    }

    public void bindSelector(SourceImpl source) {
        this.selector1 = source.getExistingSelector(this.selector1Name);
        this.selector2 = source.getExistingSelector(this.selector2Name);
    }

    @Override
    public boolean evaluate() {
        String p1 = this.selector1.currentPath();
        String p2 = this.selector2.currentPath();
        if (this.selector2Path.equals(".")) {
            return p1.equals(p2);
        }
        String pn = this.normalizePath(this.selector2Path);
        String p = PathUtils.concat(p2, pn);
        return p.equals(p1);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector1)) {
            String p2 = this.selector2.currentPath();
            if (p2 == null && f.isPreparing() && f.isPrepared(this.selector2)) {
                f.restrictPath("//path/from/join", Filter.PathRestriction.EXACT);
            } else if (p2 != null) {
                if (this.selector2Path.equals(".")) {
                    f.restrictPath(p2, Filter.PathRestriction.EXACT);
                } else {
                    String pn = this.normalizePath(this.selector2Path);
                    String p = PathUtils.concat(p2, pn);
                    f.restrictPath(p, Filter.PathRestriction.EXACT);
                }
            }
        }
        if (f.getSelector().equals(this.selector2)) {
            String p1 = this.selector1.currentPath();
            if (p1 == null && f.isPreparing() && f.isPrepared(this.selector1)) {
                f.restrictPath("//path/from/join", Filter.PathRestriction.EXACT);
            } else if (p1 != null && this.selector2Path.equals(".")) {
                f.restrictPath(p1, Filter.PathRestriction.EXACT);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
    }

    @Override
    public boolean isParent(SourceImpl source) {
        return false;
    }

    @Override
    public boolean canEvaluate(Set<SourceImpl> available) {
        return available.contains(this.selector1) && available.contains(this.selector2);
    }
}

