/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Objects;

public class RestrictionImpl
implements Restriction {
    private final RestrictionDefinition definition;
    private final PropertyState property;
    private int hashCode = 0;

    public RestrictionImpl(@NotNull PropertyState property, @NotNull RestrictionDefinition def) {
        this.definition = def;
        this.property = property;
    }

    public RestrictionImpl(@NotNull PropertyState property, boolean isMandatory) {
        this.definition = new RestrictionDefinitionImpl(property.getName(), property.getType(), isMandatory);
        this.property = property;
    }

    @Override
    @NotNull
    public RestrictionDefinition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public PropertyState getProperty() {
        return this.property;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode(this.definition, this.property, PropertyValues.create(this.property));
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RestrictionImpl) {
            RestrictionImpl other = (RestrictionImpl)o;
            return this.definition.equals(other.definition) && this.property.equals(other.property);
        }
        return false;
    }
}

