/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.retry;

import org.junit.Assert;

public class RetryLoop {
    private final long timeout;

    public RetryLoop(Condition c, int timeoutSeconds, int intervalBetweenTriesMsec) {
        this.timeout = System.currentTimeMillis() + (long)timeoutSeconds * 1000L;
        while (System.currentTimeMillis() < this.timeout) {
            try {
                if (c.isTrue()) {
                    return;
                }
            }
            catch (AssertionError ae) {
                this.reportException((Throwable)((Object)ae));
            }
            catch (Exception e) {
                this.reportException(e);
            }
            try {
                Thread.sleep(intervalBetweenTriesMsec);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.onTimeout();
        Assert.fail((String)("RetryLoop failed, condition is false after " + timeoutSeconds + " seconds: " + c.getDescription()));
    }

    protected void reportException(Throwable t) {
    }

    protected void onTimeout() {
    }

    protected long getRemainingTimeSeconds() {
        return Math.max(0L, (this.timeout - System.currentTimeMillis()) / 1000L);
    }

    public static interface Condition {
        public String getDescription();

        public boolean isTrue() throws Exception;
    }
}

