/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.providers;

import java.io.InputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={ThumbnailProvider.class}, immediate=true)
public class ImageThumbnailProvider
implements ThumbnailProvider {
    @Override
    public boolean applies(Resource resource, String metaType) {
        try {
            MimeType mt = new MimeType(metaType);
            return mt.match("image/*") || mt.match("image/svg+xml");
        }
        catch (MimeTypeParseException e) {
            return false;
        }
    }

    @Override
    public InputStream getThumbnail(Resource resource) {
        return (InputStream)resource.adaptTo(InputStream.class);
    }
}

