/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.validation.impl.util.ValidatorTypeUtil;
import org.apache.sling.validation.spi.Validator;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorMap {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorMap.class);
    private final Map<String, ValidatorMetadata> validatorMap = new ConcurrentHashMap<String, ValidatorMetadata>();

    private String getValidatorIdFromServiceProperties(Map<String, Object> properties, Class<? extends Validator> validatorClass, ServiceReference<Validator<?>> serviceReference) {
        Object id = properties.get("validator.id");
        if (id == null) {
            throw new IllegalArgumentException("Validator '" + validatorClass.getName() + "' provided from bundle " + serviceReference.getBundle().getBundleId() + " is lacking the mandatory service property " + "validator.id");
        }
        if (!(id instanceof String)) {
            throw new IllegalArgumentException("Validator '" + validatorClass.getName() + "' provided from bundle " + serviceReference.getBundle().getBundleId() + " is providing the mandatory service property " + "validator.id" + " with the wrong type " + id.getClass() + " (must be of type String)");
        }
        return (String)id;
    }

    private Integer getValidatorSeverityFromServiceProperties(Map<String, Object> properties, Validator<?> validator, ServiceReference<Validator<?>> serviceReference) {
        Object severity = properties.get("validator.severity");
        if (severity == null) {
            LOG.debug("Validator '{}' is not setting an explicit severity via the OSGi service property {}", (Object)validator.getClass().getName(), (Object)"validator.severity");
            return null;
        }
        if (!(severity instanceof Integer)) {
            throw new IllegalArgumentException("Validator '" + validator.getClass().getName() + "' provided from bundle " + serviceReference.getBundle().getBundleId() + " is providing the optional service property " + "validator.severity" + " with the wrong type " + severity.getClass() + " (must be of type Integer)");
        }
        return (Integer)severity;
    }

    public void put(@Nonnull Map<String, Object> properties, @Nonnull Validator<?> validator, ServiceReference<Validator<?>> serviceReference) {
        String validatorId = this.getValidatorIdFromServiceProperties(properties, validator.getClass(), serviceReference);
        Integer severity = this.getValidatorSeverityFromServiceProperties(properties, validator, serviceReference);
        this.put(validatorId, validator, serviceReference, severity);
    }

    /*
     * Enabled aggressive block sorting
     */
    void put(@Nonnull String id, @Nonnull Validator<?> validator, ServiceReference<Validator<?>> serviceReference, Integer severity) {
        ValidatorMetadata entry = new ValidatorMetadata(validator, serviceReference, severity);
        if (this.validatorMap.containsKey(id)) {
            ValidatorMetadata existingEntry = this.validatorMap.get(id);
            if (entry.compareTo(existingEntry) <= 0) {
                LOG.info("A Validator for the same id '{}' is already registered {} and it has a higher service ranking, therefore ignoring {}", new Object[]{id, existingEntry, entry});
                return;
            }
            LOG.info("Overwriting already existing validator {} with {}, because it has the same id '{}' and a higher service ranking", new Object[]{existingEntry, entry, id});
        } else {
            LOG.debug("New validator with id '{}' added: {}", (Object)id, (Object)entry);
        }
        this.validatorMap.put(id, entry);
    }

    public void update(@Nonnull Map<String, Object> properties, @Nonnull Validator<?> validator, ServiceReference<Validator<?>> serviceReference) {
        String validatorId = this.getValidatorIdFromServiceProperties(properties, validator.getClass(), serviceReference);
        Integer severity = this.getValidatorSeverityFromServiceProperties(properties, validator, serviceReference);
        this.update(validatorId, validator, serviceReference, severity);
    }

    void update(@Nonnull String id, @Nonnull Validator<?> validator, ServiceReference<Validator<?>> serviceReference, Integer severity) {
        LOG.info("Updating validator with id '{}'", (Object)id);
        this.remove(serviceReference);
        this.put(id, validator, serviceReference, severity);
    }

    private boolean remove(ServiceReference<Validator<?>> serviceReference) {
        Iterator<ValidatorMetadata> iterator = this.validatorMap.values().iterator();
        while (iterator.hasNext()) {
            ValidatorMetadata value = iterator.next();
            if (!value.serviceReference.equals(serviceReference)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean remove(@Nonnull Map<String, Object> properties, @Nonnull Validator<?> validator, ServiceReference<Validator<?>> serviceReference) {
        String validatorId = this.getValidatorIdFromServiceProperties(properties, validator.getClass(), serviceReference);
        return this.remove(validatorId, serviceReference);
    }

    boolean remove(String id, ServiceReference<Validator<?>> serviceReference) {
        ValidatorMetadata entry;
        if (id == null) {
            // empty if block
        }
        if ((entry = this.validatorMap.get(id)) == null) {
            LOG.warn("Could not remove validator with id '{}' from map, because it is not there!", (Object)id);
            return false;
        }
        if (entry.serviceReference.equals(serviceReference)) {
            this.validatorMap.remove(id);
            return true;
        }
        LOG.warn("Could not remove validator with id '{}' from map because it is only contained with a different service reference!", (Object)id);
        return false;
    }

    public ValidatorMetadata get(String id) {
        return this.validatorMap.get(id);
    }

    static final class ValidatorMetadata
    implements Comparable<ValidatorMetadata> {
        @Nonnull
        protected final Validator<?> validator;
        protected final Integer severity;
        @Nonnull
        protected final Class<?> type;
        @Nonnull
        protected final ServiceReference<Validator<?>> serviceReference;

        public ValidatorMetadata(Validator<?> validator, ServiceReference<Validator<?>> serviceReference, Integer severity) {
            this.validator = validator;
            this.severity = severity;
            this.serviceReference = serviceReference;
            this.type = ValidatorTypeUtil.getValidatorType(validator);
        }

        @Override
        public int compareTo(ValidatorMetadata o) {
            return this.serviceReference.compareTo(o.serviceReference);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.serviceReference == null ? 0 : this.serviceReference.hashCode());
            result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
            result = 31 * result + (this.validator == null ? 0 : this.validator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidatorMetadata other = (ValidatorMetadata)obj;
            if (this.serviceReference == null ? other.serviceReference != null : !this.serviceReference.equals(other.serviceReference)) {
                return false;
            }
            if (this.severity == null ? other.severity != null : !this.severity.equals(other.severity)) {
                return false;
            }
            return !(this.validator == null ? other.validator != null : !this.validator.equals(other.validator));
        }

        public String toString() {
            return "Entry [validator=" + this.validator + ", severity=" + this.severity + ", type=" + this.type + ", from bundle '" + this.serviceReference.getBundle().getSymbolicName() + "']";
        }

        @Nonnull
        public Validator<?> getValidator() {
            return this.validator;
        }

        @CheckForNull
        public Integer getSeverity() {
            return this.severity;
        }

        @Nonnull
        public Class<?> getType() {
            return this.type;
        }
    }
}

