/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    static final String COMMENT_CHARS = "#!";
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ESCAPE = "\\";
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private PropertiesConfigurationLayout layout;
    private boolean includesAllowed;

    public PropertiesConfiguration() {
        this.setEncoding(DEFAULT_ENCODING);
        this.layout = this.createLayout();
        this.setIncludesAllowed(false);
    }

    public PropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setEncoding(DEFAULT_ENCODING);
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
    }

    public PropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    protected void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean getIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.getLayout().getHeaderComment();
    }

    public void setHeader(String header) {
        this.getLayout().setHeaderComment(header);
    }

    public synchronized PropertiesConfigurationLayout getLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
        return this.layout;
    }

    public synchronized void setLayout(PropertiesConfigurationLayout layout) {
        if (this.layout != null) {
            this.removeConfigurationListener(this.layout);
        }
        this.layout = layout == null ? this.createLayout() : layout;
    }

    protected PropertiesConfigurationLayout createLayout() {
        return new PropertiesConfigurationLayout(this);
    }

    public synchronized void load(Reader in) throws ConfigurationException {
        boolean oldAutoSave = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.getLayout().load(in);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setAutoSave(oldAutoSave);
            throw throwable;
        }
        this.setAutoSave(oldAutoSave);
    }

    public void save(Writer writer) throws ConfigurationException {
        this.enterNoReload();
        try {
            this.getLayout().save(writer);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.exitNoReload();
            throw throwable;
        }
        this.exitNoReload();
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty((String)basePath));
    }

    public Object clone() {
        PropertiesConfiguration copy = (PropertiesConfiguration)super.clone();
        if (this.layout != null) {
            copy.setLayout(new PropertiesConfigurationLayout(copy, this.layout));
        }
        return copy;
    }

    boolean propertyLoaded(String key, String value) throws ConfigurationException {
        boolean result;
        if (StringUtils.isNotEmpty((String)PropertiesConfiguration.getInclude()) && key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
            if (this.getIncludesAllowed()) {
                String[] files = !this.isDelimiterParsingDisabled() ? StringUtils.split((String)value, (char)this.getListDelimiter()) : new String[]{value};
                int i = 0;
                while (i < files.length) {
                    this.loadIncludeFile(files[i].trim());
                    ++i;
                }
            }
            result = false;
        } else {
            this.addProperty(key, value);
            result = true;
        }
        return result;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() == 4) {
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.append((char)value);
                        unicode.setLength(0);
                        inUnicode = false;
                        hadSlash = false;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                    }
                }
            } else if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                } else if (ch == '\'') {
                    out.append('\'');
                } else if (ch == '\"') {
                    out.append('\"');
                } else if (ch == 'r') {
                    out.append('\r');
                } else if (ch == 'f') {
                    out.append('\f');
                } else if (ch == 't') {
                    out.append('\t');
                } else if (ch == 'n') {
                    out.append('\n');
                } else if (ch == 'b') {
                    out.append('\b');
                } else if (ch == delimiter) {
                    out.append('\\');
                    out.append(delimiter);
                } else if (ch == 'u') {
                    inUnicode = true;
                } else {
                    out.append(ch);
                }
            } else if (ch == '\\') {
                hadSlash = true;
            } else {
                out.append(ch);
            }
            ++i;
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    private void loadIncludeFile(String fileName) throws ConfigurationException {
        URL baseURL;
        URL url = ConfigurationUtils.locate(this.getBasePath(), fileName);
        if (url == null && (baseURL = this.getURL()) != null) {
            url = ConfigurationUtils.locate(baseURL.toString(), fileName);
        }
        if (url == null) {
            throw new ConfigurationException("Cannot resolve include file " + fileName);
        }
        this.load(url);
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private char delimiter;

        public PropertiesWriter(Writer writer, char delimiter) {
            super(writer);
            this.delimiter = delimiter;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.writeProperty(key, value, false);
        }

        public void writeProperty(String key, List values) throws IOException {
            int i = 0;
            while (i < values.size()) {
                this.writeProperty(key, values.get(i));
                ++i;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeProperty(String key, Object value, boolean forceSingleLine) throws IOException {
            String v;
            if (value instanceof List) {
                List values = (List)value;
                if (!forceSingleLine) {
                    this.writeProperty(key, values);
                    return;
                }
                v = this.makeSingleLineValue(values);
            } else {
                v = this.escapeValue(value);
            }
            this.write(this.escapeKey(key));
            this.write(" = ");
            this.write(v);
            this.writeln(null);
        }

        public void writeComment(String comment) throws IOException {
            this.writeln("# " + comment);
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            int i = 0;
            while (i < key.length()) {
                char c = key.charAt(i);
                if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                    newkey.append('\\');
                    newkey.append(c);
                } else {
                    newkey.append(c);
                }
                ++i;
            }
            return newkey.toString();
        }

        private String escapeValue(Object value) {
            String escapedValue = StringEscapeUtils.escapeJava((String)String.valueOf(value));
            if (this.delimiter != '\u0000') {
                escapedValue = StringUtils.replace((String)escapedValue, (String)String.valueOf(this.delimiter), (String)(PropertiesConfiguration.ESCAPE + this.delimiter));
            }
            return escapedValue;
        }

        private String makeSingleLineValue(List values) {
            if (!values.isEmpty()) {
                Iterator it = values.iterator();
                String lastValue = this.escapeValue(it.next());
                StringBuffer buf = new StringBuffer(lastValue);
                while (it.hasNext()) {
                    if (lastValue.endsWith(PropertiesConfiguration.ESCAPE)) {
                        buf.append(PropertiesConfiguration.ESCAPE).append(PropertiesConfiguration.ESCAPE);
                    }
                    buf.append(this.delimiter);
                    lastValue = this.escapeValue(it.next());
                    buf.append(lastValue);
                }
                return buf.toString();
            }
            return null;
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        private List commentLines = new ArrayList();
        private String propertyName;
        private String propertyValue;
        private char delimiter;

        public PropertiesReader(Reader reader) {
            this(reader, AbstractConfiguration.getDefaultListDelimiter());
        }

        public PropertiesReader(Reader reader, char listDelimiter) {
            super(reader);
            this.delimiter = listDelimiter;
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (PropertiesConfiguration.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                if (!PropertiesReader.checkCombineLines(line = line.trim())) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader.parseProperty(line);
            this.propertyName = StringEscapeUtils.unescapeJava((String)property[0]);
            this.propertyValue = PropertiesConfiguration.unescapeJava(property[1], this.delimiter);
            return true;
        }

        public List getCommentLines() {
            return this.commentLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            int idx = line.length() - 1;
            while (idx >= 0 && line.charAt(idx) == '\\') {
                ++bsCount;
                --idx;
            }
            return bsCount % 2 == 1;
        }

        private static String[] parseProperty(String line) {
            String[] result = new String[2];
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            int state = 0;
            int pos = 0;
            while (pos < line.length()) {
                char c = line.charAt(pos);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            break;
                        }
                        if (ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                            state = 2;
                            break;
                        }
                        if (ArrayUtils.contains((char[])SEPARATORS, (char)c)) {
                            state = 3;
                            break;
                        }
                        key.append(c);
                        break;
                    }
                    case 1: {
                        if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                            key.append(c);
                        } else {
                            key.append('\\');
                            key.append(c);
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                            state = 2;
                            break;
                        }
                        if (ArrayUtils.contains((char[])SEPARATORS, (char)c)) {
                            state = 3;
                            break;
                        }
                        value.append(c);
                        state = 3;
                        break;
                    }
                    case 3: {
                        value.append(c);
                    }
                }
                ++pos;
            }
            result[0] = key.toString().trim();
            result[1] = value.toString().trim();
            return result;
        }
    }
}

