/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.capability;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ProvidedScriptCapability {
    private final String path;
    private final String scriptExtension;
    private final String scriptEngine;

    private ProvidedScriptCapability(@NotNull String path, @NotNull String scriptExtension, @NotNull String scriptEngine) {
        this.path = path;
        this.scriptExtension = scriptExtension;
        this.scriptEngine = scriptEngine;
    }

    public String getPath() {
        return this.path;
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public String getScriptEngine() {
        return this.scriptEngine;
    }

    public static Builder builder(Map<String, String> scriptEngineMappings) {
        return new Builder(scriptEngineMappings);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.scriptExtension, this.scriptEngine);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvidedScriptCapability) {
            ProvidedScriptCapability other = (ProvidedScriptCapability)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.scriptExtension, other.scriptExtension) && Objects.equals(this.scriptEngine, other.scriptEngine);
        }
        return false;
    }

    public String toString() {
        return String.format("%s { path=%s; scriptExtension=%s; scriptEngine=%s }", ProvidedScriptCapability.class.getSimpleName(), this.path, this.scriptExtension, this.scriptEngine);
    }

    public static class Builder {
        private final Map<String, String> scriptEngineMappings;
        private String path;

        public Builder(Map<String, String> scriptEngineMappings) {
            this.scriptEngineMappings = scriptEngineMappings;
        }

        public ProvidedScriptCapability build() {
            int lastDotIndex = this.path.lastIndexOf(46);
            if (lastDotIndex == -1 || lastDotIndex == this.path.length() - 1) {
                throw new IllegalStateException(String.format("Path %s does not seem to have an extension.", this.path));
            }
            String extension = this.path.substring(lastDotIndex + 1);
            String scriptEngine = this.scriptEngineMappings.get(extension);
            if (StringUtils.isEmpty((CharSequence)scriptEngine)) {
                throw new IllegalStateException(String.format("Path %s does not seem to have an extension mapped to a script engine.", this.path));
            }
            return new ProvidedScriptCapability(this.path, extension, scriptEngine);
        }

        public Builder withPath(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new NullPointerException("The path cannot be null or empty.");
            }
            this.path = path;
            return this;
        }
    }
}

