/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.jcr.contentparser.impl.JsonTicksConverter;

public final class JsonSupport {
    public static final String JSON_MIME_TYPE = "application/json";
    private static final JsonReaderFactory JSON_READER_FACTORY;

    private JsonSupport() {
    }

    public static JsonObject parseObject(String jsonString) {
        try (StringReader reader = new StringReader(jsonString);){
            JsonObject jsonObject;
            block11: {
                JsonReader jsonReader = JSON_READER_FACTORY.createReader((Reader)reader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
    }

    public static JsonArray parseArray(String jsonString) {
        try (StringReader reader = new StringReader(jsonString);){
            JsonArray jsonArray;
            block11: {
                JsonReader jsonReader = JSON_READER_FACTORY.createReader((Reader)reader);
                try {
                    jsonArray = jsonReader.readArray();
                    if (jsonReader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonArray;
        }
    }

    public static void validateJsonStructure(String jsonString, boolean tickToDoubleQuote) {
        String transformedJsonString = jsonString;
        if (tickToDoubleQuote) {
            transformedJsonString = JsonTicksConverter.tickToDoubleQuote((String)jsonString);
        }
        try (StringReader reader = new StringReader(transformedJsonString);
             JsonReader jsonReader = JSON_READER_FACTORY.createReader((Reader)reader);){
            jsonReader.read();
        }
    }

    public static void accumulate(Map<String, Object> obj, String name, String value) {
        Object current = obj.get(name);
        if (current == null) {
            obj.put(name, value);
        } else if (current instanceof List) {
            ArrayList<String> array = new ArrayList<String>((List)current);
            array.add(value);
            obj.put(name, array);
        } else {
            ArrayList<String> array = new ArrayList<String>();
            array.add((String)current);
            array.add(value);
            obj.put(name, array);
        }
    }

    public static JsonObject toJson(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                builder.add(entry.getKey(), (JsonValue)JsonSupport.toJson((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof List) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                for (String value : (List)entry.getValue()) {
                    array.add(value);
                }
                builder.add(entry.getKey(), (JsonValue)array.build());
                continue;
            }
            builder.add(entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    static {
        HashMap<String, Boolean> jsonFactoryConfig = new HashMap<String, Boolean>();
        jsonFactoryConfig.put("org.apache.johnzon.supports-comments", true);
        JSON_READER_FACTORY = Json.createReaderFactory(jsonFactoryConfig);
    }
}

