/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Size;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeCheck
extends AbstractAnnotationCheck<Size> {
    private static final long serialVersionUID = 1L;
    private int min;
    private int max;

    @Override
    public void configure(Size constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.max());
        this.setMin(constraintAnnotation.min());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Integer.toString(this.max));
        messageVariables.put("min", Integer.toString(this.min));
        return messageVariables;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Collection) {
            int size = ((Collection)valueToValidate).size();
            return size >= this.min && size <= this.max;
        }
        if (valueToValidate instanceof Map) {
            int size = ((Map)valueToValidate).size();
            return size >= this.min && size <= this.max;
        }
        if (valueToValidate.getClass().isArray()) {
            int size = Array.getLength(valueToValidate);
            return size >= this.min && size <= this.max;
        }
        String str = valueToValidate.toString();
        int size = str.length();
        return size >= this.min && size <= this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }

    public void setMin(int min) {
        this.min = min;
        this.requireMessageVariablesRecreation();
    }
}

