/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.exception.ExpressionLanguageNotAvailableException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.expression.ExpressionLanguageBeanShellImpl;
import net.sf.oval.expression.ExpressionLanguageGroovyImpl;
import net.sf.oval.expression.ExpressionLanguageJEXLImpl;
import net.sf.oval.expression.ExpressionLanguageJRubyImpl;
import net.sf.oval.expression.ExpressionLanguageJavaScriptImpl;
import net.sf.oval.expression.ExpressionLanguageMVELImpl;
import net.sf.oval.expression.ExpressionLanguageOGNLImpl;
import net.sf.oval.expression.ExpressionLanguageScriptEngineImpl;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;

public class ExpressionLanguageRegistry {
    private static final Log LOG = Log.getLog(ExpressionLanguageRegistry.class);
    private final Map<String, ExpressionLanguage> elcache = Validator.getCollectionFactory().createMap(4);

    private ExpressionLanguage _initializeDefaultEL(String languageId) {
        ExpressionLanguageScriptEngineImpl el;
        if (("javascript".equals(languageId) || "js".equals(languageId)) && ReflectionUtils.isClassPresent("org.mozilla.javascript.Context")) {
            return this.registerExpressionLanguage("js", this.registerExpressionLanguage("javascript", new ExpressionLanguageJavaScriptImpl()));
        }
        if ("groovy".equals(languageId) && ReflectionUtils.isClassPresent("groovy.lang.Binding")) {
            return this.registerExpressionLanguage("groovy", new ExpressionLanguageGroovyImpl());
        }
        if (("beanshell".equals(languageId) || "bsh".equals(languageId)) && ReflectionUtils.isClassPresent("bsh.Interpreter")) {
            return this.registerExpressionLanguage("beanshell", this.registerExpressionLanguage("bsh", new ExpressionLanguageBeanShellImpl()));
        }
        if ("ognl".equals(languageId) && ReflectionUtils.isClassPresent("ognl.Ognl")) {
            return this.registerExpressionLanguage("ognl", new ExpressionLanguageOGNLImpl());
        }
        if ("mvel".equals(languageId) && ReflectionUtils.isClassPresent("org.mvel2.MVEL")) {
            return this.registerExpressionLanguage("mvel", new ExpressionLanguageMVELImpl());
        }
        if (("jruby".equals(languageId) || "ruby".equals(languageId)) && ReflectionUtils.isClassPresent("org.jruby.Ruby")) {
            return this.registerExpressionLanguage("jruby", this.registerExpressionLanguage("ruby", new ExpressionLanguageJRubyImpl()));
        }
        if ("jexl".equals(languageId) && ReflectionUtils.isClassPresent("org.apache.commons.jexl2.JexlEngine")) {
            return this.registerExpressionLanguage("jexl", new ExpressionLanguageJEXLImpl());
        }
        if (ReflectionUtils.isClassPresent("javax.script.ScriptEngineManager") && (el = ExpressionLanguageScriptEngineImpl.get(languageId)) != null) {
            return this.registerExpressionLanguage(languageId, el);
        }
        return null;
    }

    public ExpressionLanguage getExpressionLanguage(String languageId) throws IllegalArgumentException, ExpressionLanguageNotAvailableException {
        Assert.argumentNotNull("languageId", languageId);
        ExpressionLanguage el = this.elcache.get(languageId);
        if (el == null) {
            el = this._initializeDefaultEL(languageId);
        }
        if (el == null) {
            throw new ExpressionLanguageNotAvailableException(languageId);
        }
        return el;
    }

    public ExpressionLanguage registerExpressionLanguage(String languageId, ExpressionLanguage impl) throws IllegalArgumentException {
        Assert.argumentNotNull("languageId", languageId);
        Assert.argumentNotNull("impl", impl);
        LOG.info("Expression language '{1}' registered: {2}", (Object)languageId, impl);
        this.elcache.put(languageId, impl);
        return impl;
    }
}

