/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import org.mvel2.MVEL;

public class ExpressionLanguageMVELImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageMVELImpl.class);
    private final ObjectCache<String, Object> expressionCache = new ObjectCache<String, Object>(MVEL::compileExpression);

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating MVEL expression: {1}", expression);
        try {
            Object expr = this.expressionCache.get(expression);
            return MVEL.executeExpression((Object)expr, values);
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating MVEL expression failed: " + expression, ex);
        }
    }
}

