/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.AbstractMultiPartRequest;
import org.apache.struts2.dispatcher.multipart.StrutsUploadedFile;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class JakartaMultiPartRequest
extends AbstractMultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(JakartaMultiPartRequest.class);

    @Override
    protected void processUpload(HttpServletRequest request, String saveDir) throws IOException {
        Charset charset = this.readCharsetEncoding(request);
        JakartaServletDiskFileUpload servletFileUpload = this.prepareServletFileUpload(charset, Path.of(saveDir, new String[0]));
        for (DiskFileItem item : servletFileUpload.parseRequest(request)) {
            LOG.debug(() -> "Processing a form field: " + this.sanitizeNewlines(item.getFieldName()));
            if (item.isFormField()) {
                this.processNormalFormField(item, charset);
                continue;
            }
            LOG.debug(() -> "Processing a file: " + this.sanitizeNewlines(item.getFieldName()));
            this.processFileField(item);
        }
    }

    @Override
    protected JakartaServletDiskFileUpload createJakartaFileUpload(Charset charset, Path saveDir) {
        DiskFileItemFactory.Builder builder = DiskFileItemFactory.builder();
        LOG.debug("Using file save directory: {}", (Object)saveDir);
        builder.setPath(saveDir);
        LOG.debug("Sets minimal buffer size to always write file to disk");
        builder.setBufferSize(1);
        LOG.debug("Using charset: {}", (Object)charset);
        builder.setCharset(charset);
        DiskFileItemFactory factory = builder.get();
        return new JakartaServletDiskFileUpload(factory);
    }

    protected void processNormalFormField(DiskFileItem item, Charset charset) throws IOException {
        LOG.debug("Item: {} is a normal form field", (Object)item.getName());
        String fieldName = item.getFieldName();
        List values = this.parameters.get(fieldName) != null ? (List)this.parameters.get(fieldName) : new ArrayList();
        String fieldValue = item.getString(charset);
        if (this.exceedsMaxStringLength(fieldName, fieldValue)) {
            return;
        }
        if (item.getSize() == 0L) {
            values.add("");
        } else {
            values.add(fieldValue);
        }
        this.parameters.put(fieldName, values);
    }

    protected void processFileField(DiskFileItem item) {
        if (item.getName() == null || item.getName().trim().isEmpty()) {
            LOG.debug(() -> "No file has been uploaded for the field: " + this.sanitizeNewlines(item.getFieldName()));
            return;
        }
        List values = this.uploadedFiles.get(item.getFieldName()) != null ? (List)this.uploadedFiles.get(item.getFieldName()) : new ArrayList();
        if (item.isInMemory()) {
            LOG.warn("Storing uploaded files just in memory isn't supported currently, skipping file: {}!", (Object)item.getName());
        } else {
            UploadedFile uploadedFile = StrutsUploadedFile.Builder.create(item.getPath().toFile()).withOriginalName(item.getName()).withContentType(item.getContentType()).withInputName(item.getFieldName()).build();
            values.add(uploadedFile);
        }
        this.uploadedFiles.put(item.getFieldName(), values);
    }
}

