/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.ExporterConfiguration;

public class CompositeExporterConfigurationFactory<C extends CommonExportConfiguration> {
    private final JRPropertiesUtil propertiesUtil;
    private final Class<C> configurationInterface;

    public CompositeExporterConfigurationFactory(JasperReportsContext jasperReportsContext, Class<C> configurationInterface) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.configurationInterface = configurationInterface;
    }

    public C getConfiguration(C parent, C child) {
        if (parent == null) {
            return child;
        }
        boolean isOverrideHints = parent.isOverrideHints() == null ? this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.configuration.override.report.hints") : parent.isOverrideHints().booleanValue();
        return this.getConfiguration(parent, child, isOverrideHints);
    }

    public C getConfiguration(C parent, C child, boolean isOverrideHints) {
        if (parent == null) {
            return child;
        }
        if (isOverrideHints) {
            return this.getProxy(this.configurationInterface, new DelegateInvocationHandler(this, child, parent));
        }
        return this.getProxy(this.configurationInterface, new DelegateInvocationHandler(this, parent, child));
    }

    private final C getProxy(Class<?> clazz, InvocationHandler handler) {
        ArrayList allInterfaces = new ArrayList();
        if (clazz.isInterface()) {
            allInterfaces.add(clazz);
        } else {
            List<Class<?>> lcInterfaces = ClassUtils.getInterfaces(clazz);
            allInterfaces.addAll(lcInterfaces);
        }
        CommonExportConfiguration composite = (CommonExportConfiguration)Proxy.newProxyInstance(ExporterConfiguration.class.getClassLoader(), allInterfaces.toArray(new Class[allInterfaces.size()]), handler);
        return (C)composite;
    }

    static class DelegateInvocationHandler
    implements InvocationHandler {
        private final C parent;
        private final C child;
        final /* synthetic */ CompositeExporterConfigurationFactory this$0;

        public DelegateInvocationHandler(C parent, C child) {
            this.this$0 = this$0;
            this.parent = parent;
            this.child = child;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value;
            Object object = value = this.child == null ? null : method.invoke(this.child, args);
            if (value == null) {
                value = this.parent == null ? null : method.invoke(this.parent, args);
            }
            return value;
        }
    }
}

