/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;

public class CloneMediator
extends AbstractMediator
implements ManagedLifecycle {
    private boolean continueParent = false;
    private List<Target> targets = new ArrayList<Target>();
    private String id = null;
    private boolean sequential = false;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Clone mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        Iterator<Target> iter = this.targets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Submitting " + (i + 1) + " of " + this.targets.size() + " messages for processing in parallel");
            }
            iter.next().mediate(this.getClonedMessageContext(synCtx, i++, this.targets.size()));
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Clone mediator");
        return this.continueParent;
    }

    private MessageContext getClonedMessageContext(MessageContext synCtx, int messageSequence, int messageCount) {
        MessageContext newCtx = null;
        try {
            newCtx = MessageHelper.cloneMessageContext(synCtx);
            ((Axis2MessageContext)newCtx).getAxis2MessageContext().setServerSide(((Axis2MessageContext)synCtx).getAxis2MessageContext().isServerSide());
            if (this.id != null) {
                newCtx.setProperty("aggregateCorelation." + this.id, synCtx.getMessageID());
                newCtx.setProperty("messageSequence." + this.id, String.valueOf(messageSequence) + "/" + messageCount);
            } else {
                newCtx.setProperty("messageSequence", String.valueOf(messageSequence) + "/" + messageCount);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error cloning the message context", (Exception)((Object)axisFault), synCtx);
        }
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    @Override
    public void init(SynapseEnvironment se) {
        for (Target target : this.targets) {
            Endpoint endpoint;
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.init(se);
            }
            if ((endpoint = target.getEndpoint()) == null) continue;
            endpoint.init(se);
        }
    }

    @Override
    public void destroy() {
        for (Target target : this.targets) {
            Endpoint endpoint;
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.destroy();
            }
            if ((endpoint = target.getEndpoint()) == null) continue;
            endpoint.destroy();
        }
    }
}

