/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.synapse.core.SynapseEnvironment;

public class SynapseBinaryDataSource
implements DataSource {
    private String contentType;
    private OverflowBlob data;

    public SynapseBinaryDataSource(InputStream inputstream, String contentType) throws IOException {
        this.contentType = contentType;
        this.data = new OverflowBlob(4, 1024, "tmp_", ".dat");
        this.data.readFrom(inputstream, -1L);
        inputstream.close();
    }

    public SynapseBinaryDataSource(InputStream inputstream, String contentType, SynapseEnvironment synEnv) throws IOException {
        this.contentType = contentType;
        this.data = synEnv.createOverflowBlob();
        this.data.readFrom(inputstream, -1L);
        inputstream.close();
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return this.data.getInputStream();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.data.getOutputStream();
    }
}

